/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class BooleanType extends BaseType implements SwitchTypeSpec {

	public BooleanType(int num) {
		super(num);
	}

	public String typeName() {
		return "boolean";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		return 8;
	}

	public String toString() {
		return typeName();
	}

	public void parse()

	{
	}

	public String holderName() {
		return "org.omg.CORBA.BooleanHolder";
	}

	public String printReadExpression(String strname) {
		return strname + ".read_boolean()";
	}

	public String printWriteStatement(String var_name, String strname) {
		return strname + ".write_boolean(" + var_name + ");";
	}

	public String printInsertExpression() {
		return "insert_boolean";
	}

	public String printExtractExpression() {
		return "extract_boolean";
	}

	public boolean isSwitchable() {
		return true;
	}
}
