/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class CharType extends BaseType implements SwitchTypeSpec {
	private boolean wide = false;

	public CharType(int num) {
		super(num);
	}

	public Object clone() {
		CharType s = new CharType(new_num());
		if (wide)
			s.setWide();
		return s;
	}

	public boolean isWide() {
		return wide;
	}

	public void setWide() {
		wide = true;
	}

	public String typeName() {
		return "char";
	}

	public String idlTypeName() {
		return (wide ? "wchar" : "char");
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public String toString() {
		return typeName();
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		if (wide)
			return 26;
		else
			return 9;
	}

	public String holderName() {
		return "org.omg.CORBA.CharHolder";
	}

	public String printReadExpression(String strname) {
		if (wide)
			return strname + ".read_wchar()";
		else
			return strname + ".read_char()";
	}

	public String printWriteStatement(String var_name, String strname) {
		if (wide)
			return strname + ".write_wchar(" + var_name + ");";
		else
			return strname + ".write_char(" + var_name + ");";
	}

	public String printInsertExpression() {
		if (wide)
			return "insert_wchar";
		else
			return "insert_char";

	}

	public String printExtractExpression() {
		if (wide)
			return "extract_wchar";
		else
			return "extract_char";
	}

	public boolean isSwitchable() {
		// wchar is not a valid union discriminator type

		return !wide;
	}
}
