/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class ConstExpr extends IdlSymbol {

	public OrExpr or_expr;

	public ConstExpr(int num) {
		super(num);
	}

	public void parse() {
		or_expr.parse();
	}

	public void setDeclaration(ConstDecl declared_in) {
		or_expr.setDeclaration(declared_in);
	}

	public void print(PrintWriter ps) {
		or_expr.print(ps);
	}

	int pos_int_const() {
		return or_expr.pos_int_const();
	}

	public String toString() {
		// return value();
		return or_expr.toString();
	}

	public str_token get_token() {
		return or_expr.get_token();
	}

	public String value() {
		return or_expr.value();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		or_expr.setPackage(s);
	}
}
