/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class ConstrTypeSpec extends TypeSpec {
	public TypeDeclaration c_type_spec;
	private boolean parsed = false;

	public ConstrTypeSpec(int num) {
		super(num);
	}

	public ConstrTypeSpec(TypeDeclaration c) {
		super(new_num());
		c_type_spec = c;
	}

	public void set_name(String n) {
		c_type_spec.set_name(n);
	}

	public Object clone() {
		ConstrTypeSpec cts = new ConstrTypeSpec(new_num());
		cts.c_type_spec = (TypeDeclaration) c_type_spec.clone();
		return cts;
	}

	public TypeDeclaration declaration() {
		return c_type_spec;
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
		c_type_spec.setEnclosingSymbol(s);
	}

	public String toString() {
		String n = typeName();
		if (!n.startsWith("org.omg")) {
			return omgPrefix() + n;
		} else
			return n;
	}

	public String typeName() {
		return c_type_spec.typeName();
	}

	public String full_name() {
		return c_type_spec.full_name();
	}

	/**
	 * @return "org.omg." if the symbol has been declare inside a scope with a
	 *         pragma prefix of "omg.org"
	 */

	public String omgPrefix() {
		return c_type_spec.omg_package_prefix;
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public boolean basic() {
		return c_type_spec.basic();
	}

	public void parse() {
		c_type_spec.parse();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		c_type_spec.setPackage(s);
	}

	public String getTypeCodeExpression(java.util.Set knownTypeSpecs) {
		return c_type_spec.getTypeCodeExpression(knownTypeSpecs);
	}

	/**
	 * @return a string for an expression of type TypeCode that describes this
	 *         type
	 */
	public String getTypeCodeExpression() {
		return c_type_spec.getTypeCodeExpression();
	}

	public void print(PrintWriter ps) {
		c_type_spec.print(ps);
	}

	public String holderName() {
		return c_type_spec.holderName();
	}

	public String printReadExpression(String streamname) {
		return c_type_spec.printReadExpression(streamname);
	}

	// public String printReadStatement(String var_name, String streamname)
	// {
	// return c_type_spec.printReadStatement(var_name, streamname);
	// }

	public String printWriteStatement(String var_name, String streamname) {
		return c_type_spec.printWriteStatement(var_name, streamname);
	}

	public String printInsertExpression() {
		throw new RuntimeException("Should not be called");
	}

	public String printExtractExpression() {
		throw new RuntimeException("Should not be called");
	}

	public String id() {
		return c_type_spec.declaration().id();
	}

}
