/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class Declarator extends IdlSymbol {

	public Declarator d;

	public Declarator(int num) {
		super(num);
	}

	public String name() {
		return d.name();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		d.setPackage(s);
	}

	public void set_included(boolean i) {
		included = i;
		d.set_included(i);
	}

	String full_name() {
		return d.full_name();
	}

	/**
	 * @overrides escapeName from IdlSymbol
	 */

	public void escapeName() {
		d.escapeName();
	}

	public void parse() {
		d.parse();
	}

	public void print(PrintWriter ps) {
	}

	public String toString() {
		return d.toString();
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		d.setEnclosingSymbol(s);
	}

	public IdlSymbol getEnclosingSymbol() {
		return d.getEnclosingSymbol();
	}
}
