/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class FixedPointConstType extends BaseType {

	public FixedPointConstType(int num) {
		super(num);
	}

	public Object clone() {
		return new FixedPointConstType(new_num());
	}

	public String typeName() {
		return "java.math.BigDecimal";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public String toString() {
		return typeName();
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		return 28;
	}

	public void parse() {
	}

	public String holderName() {
		return "org.omg.CORBA.FixedHolder";
	}

	public String printReadExpression(String strname) {
		return strname + ".read_fixed()";
	}

	public String printWriteStatement(String var_name, String strname) {
		return strname + ".write_fixed(" + var_name + ");";
	}
}
