/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class InitParamDecl extends ParamDecl {

	public InitParamDecl(int num) {
		super(num);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		paramTypeSpec.setPackage(s);
	}

	public void parse() {
		while (paramTypeSpec.typeSpec() instanceof ScopedName) {
			TypeSpec ts = ((ScopedName) paramTypeSpec.typeSpec())
					.resolvedTypeSpec();

			if (ts != null)
				paramTypeSpec = ts;
		}
	}

	public void print(PrintWriter ps) {
		ps.print(paramTypeSpec.toString() + " " + simple_declarator);
	}

	public String printWriteStatement(String ps) {
		return printWriteStatement(simple_declarator.toString(), ps);
	}

	public String printWriteStatement(String name, String ps) {
		return paramTypeSpec.typeSpec().printWriteStatement(name, ps);
	}

	public String printReadExpression(String ps) {
		return paramTypeSpec.typeSpec().printReadExpression(ps);
	}

}
