/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class LongLongType extends IntType {

	public LongLongType(int num) {
		super(num);
	}

	public Object clone() {
		return new LongLongType(new_num());
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public String typeName() {
		return "long";
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		if (unsigned)
			return 24; // tk_ulonglong
		else
			return 23; // tk_longlong
	}

	public String toString() {
		return typeName();
	}

	public String holderName() {
		return "org.omg.CORBA.LongHolder";
	}

	public String printReadExpression(String strname) {
		if (unsigned)
			return strname + ".read_ulonglong()";
		else
			return strname + ".read_longlong()";
	}

	public String printReadStatement(String var_name, String strname) {
		if (unsigned)
			return var_name + "=" + strname + ".read_ulonglong();";
		else
			return var_name + "=" + strname + ".read_longlong();";
	}

	public String printWriteStatement(String var_name, String strname) {
		if (unsigned)
			return strname + ".write_ulonglong(" + var_name + ");";
		else
			return strname + ".write_longlong(" + var_name + ");";
	}

	public String printInsertExpression() {
		if (unsigned)
			return "insert_ulonglong";
		else
			return "insert_longlong";
	}

	public String printExtractExpression() {
		if (unsigned)
			return "extract_ulonglong";
		else
			return "extract_longlong";
	}
}
