/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class ParamDecl extends IdlSymbol {
	public int paramAttribute;
	public TypeSpec paramTypeSpec;
	public SimpleDeclarator simple_declarator;

	public ParamDecl(int num) {
		super(num);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		paramTypeSpec.setPackage(s);
	}

	public void parse() {
		while (paramTypeSpec.typeSpec() instanceof ScopedName) {
			TypeSpec ts = ((ScopedName) paramTypeSpec.typeSpec())
					.resolvedTypeSpec();
			if (ts != null)
				paramTypeSpec = ts;
		}

		Environment.doAssert(paramTypeSpec != null, " paramTypeSpec is null "
				+ name);

		// simple_declarator.print(ps);
	}

	public void print(PrintWriter ps) {
		switch (paramAttribute) {
		case 1:
			// if( paramTypeSpec instanceof ConstrTypeSpec )
			// ps.print( paramTypeSpec.typeName() );
			// else
			ps.print(paramTypeSpec.toString());
			break;
		case 2: /* out */
		case 3: /* inout */
			ps.print(paramTypeSpec.holderName());
			break;
		}
		ps.print(" " + simple_declarator);
		// simple_declarator.print(ps);
	}

	public String printWriteStatement(String ps) {
		return printWriteStatement(simple_declarator.toString(), ps);
	}

	public String printWriteStatement(String name, String ps) {
		if (paramAttribute != 1)
			return paramTypeSpec.typeSpec().printWriteStatement(
					name + ".value", ps);
		else
			return paramTypeSpec.typeSpec().printWriteStatement(name, ps);
	}

	public String printReadExpression(String ps) {
		return paramTypeSpec.typeSpec().printReadExpression(ps);
	}

}
