/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class PosIntConst extends IdlSymbol {

	public ConstExpr const_expr;

	public PosIntConst(int num) {
		super(num);
	}

	public void parse() {
		const_expr.parse();
	}

	public int value() {
		return const_expr.pos_int_const();
	}

	public String toString() {
		return const_expr.toString();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		const_expr.setPackage(s);
	}
}
