/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class RaisesExpr extends IdlSymbol {

	public Vector nameList;

	public RaisesExpr(int num) {
		super(num);
		nameList = new Vector();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		for (Enumeration e = nameList.elements(); e.hasMoreElements(); ((ScopedName) e
				.nextElement()).setPackage(s))
			;
	}

	public boolean empty() {
		return (nameList.size() == 0);
	}

	public String[] getExceptionNames() {
		String[] result = new String[nameList.size()];
		Enumeration e = nameList.elements();
		for (int i = 0; i < result.length; i++) {
			result[i] = ((ScopedName) e.nextElement()).toString();
		}
		return result;
	}

	public String[] getExceptionIds() {
		String[] result = new String[nameList.size()];
		Enumeration e = nameList.elements();
		for (int i = 0; i < result.length; i++) {
			result[i] = ((ScopedName) e.nextElement()).id();
		}
		return result;
	}

	public String[] getExceptionClassNames() {
		String[] result = new String[nameList.size()];
		Enumeration e = nameList.elements();
		for (int i = 0; i < result.length; i++) {
			result[i] = ((ScopedName) e.nextElement()).toString();
		}
		return result;
	}

	public void parse() {
		Hashtable h = new Hashtable(); // for removing duplicate exception names
		for (Enumeration e = nameList.elements(); e.hasMoreElements();) {
			ScopedName name = null;
			try {
				name = (ScopedName) e.nextElement();
				TypeSpec ts = name.resolvedTypeSpec();
				if (((StructType) ((ConstrTypeSpec) ts).declaration())
						.isException()) {
					h.put(name.resolvedName(), name);
					continue; // ok
				}
				// else: go to the exception
			} catch (Exception ex) {
				// any type cast errors
				// ex.printStackTrace();
			}
			parser.fatal_error(
					"Illegal type in raises clause: " + name.toString(), token);
		}
		// remove duplicate exceptions, i.e. ScopedNames that, when
		// fully qualified, point to the same exception declaration
		nameList = new Vector();
		for (Enumeration e = h.keys(); e.hasMoreElements();) {
			nameList.addElement(h.get((String) e.nextElement()));
		}
		h.clear();
		String[] classes = getExceptionClassNames();

		IdlSymbol myInterface = enclosing_symbol;

		for (int i = 0; i < classes.length; i++) {
			myInterface.addImportedName(classes[i]);
		}
	}

	public void print(PrintWriter ps) {
		Enumeration e = nameList.elements();
		if (e.hasMoreElements()) {
			ps.print(" throws " + ((ScopedName) e.nextElement()));
		}
		for (; e.hasMoreElements();) {
			ps.print("," + ((ScopedName) e.nextElement()));
		}
	}
}
