/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class ShiftExpr extends IdlSymbol {

	public ShiftExpr shift_expr = null;
	public AddExpr add_expr;
	public String operator;

	public ShiftExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		if (shift_expr != null) {
			shift_expr.print(ps);
			ps.print(operator);
		}
		add_expr.print(ps);
	}

	public void setDeclaration(ConstDecl declared_in) {
		add_expr.setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		if (shift_expr != null) {
			shift_expr.setPackage(s);
		}
		add_expr.setPackage(s);
	}

	public void parse() {
		if (shift_expr != null) {
			shift_expr.parse();
		}
		add_expr.parse();
	}

	int pos_int_const() {
		return add_expr.pos_int_const();
	}

	public String value() {
		String x = "";
		if (shift_expr != null) {
			x = shift_expr.value() + operator;
		}
		return x + add_expr.value();
	}

	public String toString() {
		String x = "";
		if (shift_expr != null) {
			x = shift_expr + operator;
		}
		return x + add_expr;
	}

	public str_token get_token() {
		return add_expr.get_token();
	}
}
