/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

class ShortType extends IntType {

	public ShortType(int num) {
		super(num);
	}

	public String typeName() {
		return "short";
	}

	public TypeSpec typeSpec() {
		return this;
	}

	public boolean basic() {
		return true;
	}

	public int getTCKind() {
		if (unsigned)
			return 4; // _tk_ushort
		else
			return 2; // _tk_short
	}

	public String toString() {
		return typeName();
	}

	public String holderName() {
		return "org.omg.CORBA.ShortHolder";
	}

	public String printReadExpression(String ps) {
		if (unsigned)
			return ps + ".read_ushort()";
		else
			return ps + ".read_short()";
	}

	public String printReadStatement(String var_name, String ps) {
		if (unsigned)
			return var_name + "=" + ps + ".read_ushort();";
		else
			return var_name + "=" + ps + ".read_short();";
	}

	public String printWriteStatement(String var_name, String ps) {
		if (unsigned)
			return ps + ".write_ushort(" + var_name + ");";
		else
			return ps + ".write_short(" + var_name + ");";
	}

	public String printInsertExpression() {
		if (unsigned)
			return "insert_ushort";
		else
			return "insert_short";
	}

	public String printExtractExpression() {
		if (unsigned)
			return "extract_ushort";
		else
			return "extract_short";
	}
}
