/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

class Spec extends IdlSymbol {

	public Vector definitions;

	public Spec(int num) {
		super(num);
		definitions = new Vector();
	}

	public void parse() {
		Enumeration e = definitions.elements();
		for (; e.hasMoreElements();)
			((IdlSymbol) e.nextElement()).parse();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		Enumeration e = definitions.elements();
		while (e.hasMoreElements()) {
			IdlSymbol i = (IdlSymbol) e.nextElement();
			i.setPackage(s);
		}
	}

	public void print(PrintWriter ps) {
		Enumeration e = definitions.elements();
		while (e.hasMoreElements())
			((IdlSymbol) e.nextElement()).print(ps);
	}
}
