/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class UnaryExpr extends IdlSymbol {

	public String unary_op = "";
	public PrimaryExpr primary_expr;

	public UnaryExpr(int num) {
		super(num);
	}

	public void print(PrintWriter ps) {
		ps.print(unary_op);
		primary_expr.print(ps);
	}

	public void setDeclaration(ConstDecl declared_in) {
		primary_expr.setDeclaration(declared_in);
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		if (pack_name.length() > 0)
			pack_name = new String(s + "." + pack_name);
		else
			pack_name = s;
		primary_expr.setPackage(s);
	}

	public void parse() {
		primary_expr.parse();
	}

	int pos_int_const() {
		int y = primary_expr.pos_int_const();
		if (!unary_op.equals("")) {
			if (unary_op.equals("-"))
				return y * -1;
			else
				return y;
		} else
			return y;
	}

	public String value() {
		return unary_op + primary_expr.value();
	}

	public String toString() {
		return unary_op.toString() + primary_expr.toString();
	}

	public str_token get_token() {
		return primary_expr.get_token();
	}

}
