/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class Value extends TypeDeclaration {
	private Value value;

	public Value(int num) {
		super(num);
		pack_name = "";
	}

	public Object clone() {
		return value.clone();
	}

	public void setValue(Value value) {
		this.value = value;
	}

	public TypeDeclaration declaration() {
		return value;
	};

	public String typeName() {
		return value.typeName();
	}

	/**
	 * @return a string for an expression of type TypeCode that describes this
	 *         type
	 */

	public String getTypeCodeExpression() {
		return value.getTypeCodeExpression();
	}

	public boolean basic() {
		return value.basic();
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
		value.setPackage(s);
	}

	public void set_included(boolean i) {
		included = i;
		value.set_included(i);
	}

	public void parse() {
		value.parse();
	}

	public String holderName() {
		return value.holderName();
	}

	public void print(PrintWriter ps) {
		value.print(ps);
	}

	public String toString() {
		return value.toString();
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s) {
			System.err.println("was " + enclosing_symbol.getClass().getName()
					+ " now: " + s.getClass().getName());
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		}
		enclosing_symbol = s;
		value.setEnclosingSymbol(s);
	}

	public String printReadExpression(String streamname) {
		return value.printReadExpression(streamname);
	}

	public String printReadStatement(String var_name, String streamname) {
		return value.printReadStatement(var_name, streamname);
	}

	public String printWriteStatement(String var_name, String streamname) {
		return value.printWriteStatement(var_name, streamname);
	}

}
