/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.idl;

import java.io.PrintWriter;

class VoidTypeSpec extends TypeSpec {

	public VoidTypeSpec(int num) {
		super(num);
	}

	public String typeName() {
		return "void";
	}

	public String typeSignature() {
		return "V";
	}

	public void print(PrintWriter ps) {
	}

	public String toString() {
		return typeName();
	}

	public void setEnclosingSymbol(IdlSymbol s) {
		if (enclosing_symbol != null && enclosing_symbol != s)
			throw new RuntimeException(
					"Compiler Error: trying to reassign container for " + name);
		enclosing_symbol = s;
	}

	public void setPackage(String s) {
		s = parser.pack_replace(s);
	}

	public void parse() {
	}

	public TypeSpec typeSpec() {
		return this;
	}
}
