/* Orbas Naming Server:
 *     A open source CORBA CosNaming implementation from Huihoo.
 *
 * Copyright 2003 Huihoo Power, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */
package org.huihoo.orbas.naming;

/**
 * <p>Description: </p>
 * Naming Server main application.
 * <p>Copyright (c) 2003</p>
 * <p>Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.util.Logger;
import org.huihoo.orbas.util.LoggerFactory;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class NamingServer {
	// Logger tool.
	private static Logger logger = LoggerFactory.getLogger("OrbasNS");

	public NamingServer() {
	}

	public static void main(String[] args) {
		//
		String iorFile = "orbas_naming.ior";
		//
		try {
			// init ORB

			java.util.Properties props = new java.util.Properties();

			props.setProperty("org.omg.CORBA.ORBClass",
					"org.huihoo.orbas.orb.ORB");
			props.setProperty("org.omg.CORBA.ORBSingletonClass",
					"org.huihoo.orbas.orb.ORBSingleton");

			org.huihoo.orbas.orb.ORB orb = (org.huihoo.orbas.orb.ORB) ORB.init(
					args, props);
			// init POA
			POA poa = POAHelper.narrow(orb
					.resolve_initial_references("RootPOA"));
			poa.the_POAManager().activate();
			// create a GoodDay object
			NamingContextExtImpl impl = new NamingContextExtImpl(orb, poa);
			// create the object reference
			// org.omg.CORBA.Object obj = poa.servant_to_reference(impl);
			org.omg.CORBA.Object obj = orb.binding("NameService", impl);
			/*
			 * PrintWriter pw = new PrintWriter(new FileWriter(iorFile)); //
			 * print stringified object reference to file
			 * pw.println(orb.object_to_string(obj)); pw.flush(); pw.close();
			 */
			// wait for requests
			logger.info("NameService running...");
			orb.run();
		} catch (Exception e) {
			System.out.println(e);
			e.printStackTrace();
		}

	}

}