/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb;

/**
 * <p>Description: </p>
 * Inter ORB Protocol engine class.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.poa.OrbasPoa;

public class IopEngine {

	protected ORB orb;

	public IopEngine(ORB orb) {
		this.orb = orb;
	}

	public org.omg.CORBA.portable.OutputStream invoke(byte[] objectKey,
			String op, org.omg.CORBA.portable.InputStream is,
			org.huihoo.orbas.orb.ServerWorker handler)
			throws org.omg.CORBA.SystemException,
			org.omg.PortableServer.POAPackage.AdapterNonExistent,
			org.omg.PortableServer.ForwardRequest {

		// depart poa id and objectid,locate poa then invoke
		String stringKey = new String(objectKey);
		// System.out.println("Received object key is " + stringKey);
		String poaId;
		byte[] oid;

		int index = stringKey.indexOf('/');
		if (index == -1) {
			throw new org.omg.CORBA.OBJECT_NOT_EXIST("Malformed object key");
		}
		poaId = new String(objectKey, 0, index);
		String stringOid = new String(objectKey, index + 1, objectKey.length
				- index - 1);
		oid = stringOid.getBytes();

		OrbasPoa poa = orb.locatePoa(poaId);
		if (poa == null) {
			throw new org.omg.PortableServer.POAPackage.AdapterNonExistent(
					"Can not locate POA");
		}

		org.omg.CORBA.portable.OutputStream out = null;

		try {
			out = poa.invoke(oid, op, is, handler);
		} catch (org.omg.CORBA.BAD_PARAM e1) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/BAD_PARAM:1.0");
			out.write_long(e1.minor);
			out.write_long(e1.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/BAD_PARAM:1.0");
			System.out.println("Minor code: " + e1.minor);
		} catch (org.omg.CORBA.NO_MEMORY e2) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/NO_MEMORY:1.0");
			out.write_long(e2.minor);
			out.write_long(e2.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/NO_MEMORY:1.0");
			System.out.println("Minor code: " + e2.minor);
		} catch (org.omg.CORBA.IMP_LIMIT e3) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/IMP_LIMIT:1.0");
			out.write_long(e3.minor);
			out.write_long(e3.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/IMP_LIMIT:1.0");
			System.out.println("Minor code: " + e3.minor);
		} catch (org.omg.CORBA.COMM_FAILURE e4) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/COMM_FAILURE:1.0");
			out.write_long(e4.minor);
			out.write_long(e4.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/COMM_FAILURE:1.0");
			System.out.println("Minor code: " + e4.minor);
		} catch (org.omg.CORBA.INV_OBJREF e5) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INV_OBJREF:1.0");
			out.write_long(e5.minor);
			out.write_long(e5.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INV_OBJREF:1.0");
			System.out.println("Minor code: " + e5.minor);
		} catch (org.omg.CORBA.NO_PERMISSION e6) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/NO_PERMISSION:1.0");
			out.write_long(e6.minor);
			out.write_long(e6.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/NO_PERMISSION:1.0");
			System.out.println("Minor code: " + e6.minor);
		} catch (org.omg.CORBA.INTERNAL e7) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INTERNAL:1.0");
			out.write_long(e7.minor);
			out.write_long(e7.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INTERNAL:1.0");
			System.out.println("Minor code: " + e7.minor);
		} catch (org.omg.CORBA.MARSHAL e8) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/MARSHAL:1.0");
			out.write_long(e8.minor);
			out.write_long(e8.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/MARSHAL:1.0");
			System.out.println("Minor code: " + e8.minor);
		} catch (org.omg.CORBA.INITIALIZE e9) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INITIALIZE:1.0");
			out.write_long(e9.minor);
			out.write_long(e9.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INITIALIZE:1.0");
			System.out.println("Minor code: " + e9.minor);
		} catch (org.omg.CORBA.BAD_TYPECODE e10) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/BAD_TYPECODE:1.0");
			out.write_long(e10.minor);
			out.write_long(e10.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/BAD_TYPECODE:1.0");
			System.out.println("Minor code: " + e10.minor);
		} catch (org.omg.CORBA.BAD_OPERATION e11) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/BAD_OPERATION:1.0");
			out.write_long(e11.minor);
			out.write_long(e11.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/BAD_OPERATION:1.0");
			System.out.println("Minor code: " + e11.minor);
		} catch (org.omg.CORBA.NO_RESOURCES e12) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/NO_RESOURCES:1.0");
			out.write_long(e12.minor);
			out.write_long(e12.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/NO_RESOURCES:1.0");
			System.out.println("Minor code: " + e12.minor);
		} catch (org.omg.CORBA.NO_RESPONSE e13) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/NO_RESPONSE:1.0");
			out.write_long(e13.minor);
			out.write_long(e13.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/NO_RESPONSE:1.0");
			System.out.println("Minor code: " + e13.minor);
		} catch (org.omg.CORBA.PERSIST_STORE e14) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/PERSIST_STORE:1.0");
			out.write_long(e14.minor);
			out.write_long(e14.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/PERSIST_STORE:1.0");
			System.out.println("Minor code: " + e14.minor);
		} catch (org.omg.CORBA.BAD_INV_ORDER e15) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/BAD_INV_ORDER:1.0");
			out.write_long(e15.minor);
			out.write_long(e15.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/BAD_INV_ORDER:1.0");
			System.out.println("Minor code: " + e15.minor);
		} catch (org.omg.CORBA.TRANSIENT e16) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/TRANSIENT:1.0");
			out.write_long(e16.minor);
			out.write_long(e16.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/TRANSIENT:1.0");
			System.out.println("Minor code: " + e16.minor);
		} catch (org.omg.CORBA.FREE_MEM e17) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/FREE_MEM:1.0");
			out.write_long(e17.minor);
			out.write_long(e17.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/FREE_MEM:1.0");
			System.out.println("Minor code: " + e17.minor);
		} catch (org.omg.CORBA.INV_IDENT e18) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INV_IDENT:1.0");
			out.write_long(e18.minor);
			out.write_long(e18.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INV_IDENT1.0");
			System.out.println("Minor code: " + e18.minor);
		} catch (org.omg.CORBA.INV_FLAG e19) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INV_FLAG:1.0");
			out.write_long(e19.minor);
			out.write_long(e19.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INV_FLAG:1.0");
			System.out.println("Minor code: " + e19.minor);
		} catch (org.omg.CORBA.INTF_REPOS e20) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INTF_REPOS:1.0");
			out.write_long(e20.minor);
			out.write_long(e20.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INTF_REPOS:1.0");
			System.out.println("Minor code: " + e20.minor);
		} catch (org.omg.CORBA.BAD_CONTEXT e21) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/BAD_CONTEXT:1.0");
			out.write_long(e21.minor);
			out.write_long(e21.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/BAD_CONTEXT:1.0");
			System.out.println("Minor code: " + e21.minor);
		} catch (org.omg.CORBA.OBJ_ADAPTER e22) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/OBJ_ADAPTER:1.0");
			out.write_long(e22.minor);
			out.write_long(e22.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/OBJ_ADAPTER:1.0");
			System.out.println("Minor code: " + e22.minor);
		} catch (org.omg.CORBA.DATA_CONVERSION e23) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/DATA_CONVERSION:1.0");
			out.write_long(e23.minor);
			out.write_long(e23.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/DATA_CONVERSION:1.0");
			System.out.println("Minor code: " + e23.minor);
		} catch (org.omg.CORBA.OBJECT_NOT_EXIST e24) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/OBJECT_NOT_EXIST:1.0");
			out.write_long(e24.minor);
			out.write_long(e24.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/OBJECT_NOT_EXIST:1.0");
			System.out.println("Minor code: " + e24.minor);
		} catch (org.omg.CORBA.TRANSACTION_REQUIRED e25) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/TRANSACTION_REQUIRED:1.0");
			out.write_long(e25.minor);
			out.write_long(e25.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/TRANSACTION_REQUIRED:1.0");
			System.out.println("Minor code: " + e25.minor);
		} catch (org.omg.CORBA.TRANSACTION_ROLLEDBACK e26) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/TRANSACTION_ROLLEDBACK:1.0");
			out.write_long(e26.minor);
			out.write_long(e26.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/TRANSACTION_ROLLEDBACK:1.0");
			System.out.println("Minor code: " + e26.minor);
		} catch (org.omg.CORBA.INVALID_TRANSACTION e27) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INVALID_TRANSACTION:1.0");
			out.write_long(e27.minor);
			out.write_long(e27.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INVALID_TRANSACTION:1.0");
			System.out.println("Minor code: " + e27.minor);
		} catch (org.omg.CORBA.INV_POLICY e28) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/INV_POLICY:1.0");
			out.write_long(e28.minor);
			out.write_long(e28.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/INV_POLICY:1.0");
			System.out.println("Minor code: " + e28.minor);
		} catch (org.omg.CORBA.CODESET_INCOMPATIBLE e29) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/CODESET_INCOMPATIBLE:1.0");
			out.write_long(e29.minor);
			out.write_long(e29.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/CODESET_INCOMPATIBLE:1.0");
			System.out.println("Minor code: " + e29.minor);
		} catch (org.omg.CORBA.NO_IMPLEMENT e30) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/NO_IMPLEMENT:1.0");
			out.write_long(e30.minor);
			out.write_long(e30.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/NO_IMPLEMENT:1.0");
			System.out.println("Minor code: " + e30.minor);
		} catch (org.omg.CORBA.UNKNOWN e31) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/UNKNOWN:1.0");
			out.write_long(e31.minor);
			out.write_long(e31.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/UNKNOWN:1.0");
			System.out.println("Minor code: " + e31.minor);
		} catch (org.omg.CORBA.REBIND e32) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/REBIND:1.0");
			out.write_long(e32.minor);
			out.write_long(e32.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/REBIND:1.0");
			System.out.println("Minor code: " + e32.minor);
		} catch (org.omg.CORBA.TIMEOUT e33) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/TIMEOUT:1.0");
			out.write_long(e33.minor);
			out.write_long(e33.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/TIMEOUT:1.0");
			System.out.println("Minor code: " + e33.minor);
		} catch (org.omg.CORBA.TRANSACTION_UNAVAILABLE e34) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/TRANSACTION_UNAVAILABLE:1.0");
			out.write_long(e34.minor);
			out.write_long(e34.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/TRANSACTION_UNAVAILABLE:1.0");
			System.out.println("Minor code: " + e34.minor);
		} catch (org.omg.CORBA.TRANSACTION_MODE e35) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/TRANSACTION_MODE:1.0");
			out.write_long(e35.minor);
			out.write_long(e35.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/TRANSACTION_MODE:1.0");
			System.out.println("Minor code: " + e35.minor);
		} catch (org.omg.CORBA.BAD_QOS e36) {
			// genereate exception reply
			// how can we get id from exception?
			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/BAD_QOS:1.0");
			out.write_long(e36.minor);
			out.write_long(e36.completed.value());

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/BAD_QOS:1.0");
			System.out.println("Minor code: " + e36.minor);
		} catch (Exception en) {

			out = handler.createSystemExceptionReply();

			out.write_string("IDL:org/omg/CORBA/UNKNOWN:1.0");
			out.write_long(0);
			out.write_long(2);

			// shall we print this exception out?
			System.out.println("SystemException generated from local : "
					+ "IDL:org/omg/CORBA/UNKNOWN:1.0");

		}

		return out;
	}

	public void locate() throws org.omg.PortableServer.ForwardRequest {

	}

}