/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb;

/**
 * <p>Description: </p>
 * Servant delegate which implement servant inherited operations.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.omg.PortableServer.Current;

public class ServantDelegate implements
		org.omg.PortableServer.portable.Delegate {
	private ORB orb;

	public ServantDelegate(ORB orb) {
		this.orb = orb;
	}

	public boolean is_a(org.omg.PortableServer.Servant self,
			java.lang.String repository_id) {
		String[] ids = self._all_interfaces(null, null);
		boolean flag = false;

		for (int i = 0; i < ids.length; i++) {
			if (ids[i].equals(repository_id)) {
				flag = true;
				break;
			}
		}

		return flag;
	}

	public boolean non_existent(org.omg.PortableServer.Servant self) {
		return (orb == null) ? true : false;
	}

	public org.omg.PortableServer.POA default_POA(
			org.omg.PortableServer.Servant self) {
		return (org.omg.PortableServer.POA) orb.getRootPOA();
	}

	public org.omg.CORBA.Object get_interface_def(
			org.omg.PortableServer.Servant self) {
		throw new org.omg.CORBA.NO_IMPLEMENT();
	}

	public org.omg.CORBA.ORB orb(org.omg.PortableServer.Servant self) {
		return orb;
	}

	public org.omg.CORBA.Object this_object(org.omg.PortableServer.Servant self) {
		org.omg.PortableServer.POA poa;
		try {
			poa = this.poa(self);
		} catch (org.omg.CORBA.OBJ_ADAPTER ex) {
			poa = this.default_POA(self);
		}

		try {
			return poa.servant_to_reference(self);
		} catch (org.omg.PortableServer.POAPackage.ServantNotActive snac) {
			throw new org.omg.CORBA.OBJ_ADAPTER(snac.toString());
		} catch (org.omg.PortableServer.POAPackage.WrongPolicy wpl) {
			throw new org.omg.CORBA.OBJ_ADAPTER(wpl.toString());
		}
	}

	public org.omg.PortableServer.POA poa(org.omg.PortableServer.Servant self) {
		try {
			// check the current thread to see if there is any contex
			org.omg.PortableServer.POA poa = org.omg.PortableServer.POAHelper
					.narrow(this.orb.resolve_initial_references("RootPOA"));
			return poa;
		} catch (Exception ex) {
		}
		throw new org.omg.CORBA.OBJ_ADAPTER("No Root POA");
	}

	public byte[] object_id(org.omg.PortableServer.Servant self) {
		try {
			org.omg.PortableServer.Current cur = (Current) this.orb
					.resolve_initial_references("POACurrent");
			return cur.get_object_id();
		} catch (Exception ex) {
		}
		throw new org.omg.CORBA.OBJ_ADAPTER("delegate.object_id()"
				+ "current thread has no" + "context");
	}

	/** @deprecated Deprecated by CORBA 2.4 */
	public org.omg.CORBA.InterfaceDef get_interface(
			org.omg.PortableServer.Servant self) {
		throw new org.omg.CORBA.NO_IMPLEMENT();
	}
}
