/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb;

/**
 * <p>Description: </p>
 * Pluggable factory class which create TypeCode object.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.omg.CORBA.StructMember;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;

public abstract class TypeCodeFactory {

	static TypeCodeFactory typeCodeFactory = null;

	public static TypeCodeFactory getInstance() {

		if (typeCodeFactory == null) {
			try {
				typeCodeFactory = (TypeCodeFactory) (Class
						.forName("org.huihoo.orbas.orb.typecode.TypeCodeFactory_impl")
						.newInstance());
			} catch (ClassNotFoundException ec) {
				System.out.println(ec.toString());
			} catch (java.lang.InstantiationException ei) {
				System.out.println(ei.toString());
			} catch (java.lang.IllegalAccessException eill) {
				System.out.println(eill.toString());
			}

		}

		return typeCodeFactory;
	}

	public abstract org.omg.CORBA.TypeCode get_primitive_tc(
			org.omg.CORBA.TCKind tcKind);

	public abstract TypeCode create_struct_tc(String id, String name,
			StructMember[] members);

	public abstract TypeCode create_union_tc(String id, String name,
			TypeCode discriminator_type, UnionMember[] members);

	public abstract TypeCode create_enum_tc(String id, String name,
			String[] members);

	public abstract TypeCode create_alias_tc(String id, String name,
			TypeCode original_type);

	public abstract TypeCode create_exception_tc(String id, String name,
			StructMember[] members);

	public abstract TypeCode create_interface_tc(String id, String name);

	public abstract TypeCode create_string_tc(int bound);

	public abstract TypeCode create_wstring_tc(int bound);

	public abstract org.omg.CORBA.TypeCode create_fixed_tc(short digits,
			short scale);

	public abstract org.omg.CORBA.TypeCode create_sequence_tc(int bound,
			TypeCode element_type);

	/** @deprecated by CORBA 2.3 */
	public abstract org.omg.CORBA.TypeCode create_recursive_sequence_tc(
			int bound, int offset);

	public abstract org.omg.CORBA.TypeCode create_array_tc(int length,
			TypeCode element_type);

	public abstract org.omg.CORBA.TypeCode create_value_tc(String id,
			String name, short type_modifier, TypeCode concrete_base,
			ValueMember[] members);

	public abstract org.omg.CORBA.TypeCode create_value_box_tc(String id,
			String name, TypeCode boxed_type);

	public abstract org.omg.CORBA.TypeCode create_native_tc(String id,
			String name);

	public abstract org.omg.CORBA.TypeCode create_recursive_tc(String id);

	public abstract org.omg.CORBA.TypeCode create_abstract_interface_tc(
			String id, String name);

	public abstract org.omg.CORBA.TypeCode create_local_interface_tc(String id,
			String name);
}
