/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.protocols.iiop;

/**
 * <p>Description: </p>
 * Transport for TCP procotol.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.protocols.TargetAddress;
import org.huihoo.orbas.orb.protocols.Transport;

public class IiopTransport extends Transport {

	private IiopTargetAddress address;
	private final java.net.Socket sock;
	private java.io.InputStream istream;
	private java.io.OutputStream ostream;

	private IiopChannel channel;

	public IiopTransport(IiopChannel ch, java.net.Socket sock,
			IiopTargetAddress a) {
		this.channel = ch;
		this.sock = sock;
		this.address = a;

		try {
			istream = new java.io.DataInputStream(sock.getInputStream());
			ostream = new java.io.DataOutputStream(sock.getOutputStream());
		} catch (java.io.IOException e) {
			System.out.println("IOException in IiopTransport constructor");
		}

	}

	public int getProtocolTag() {
		return org.omg.IOP.TAG_INTERNET_IOP.value;
	}

	public TargetAddress getTargetAddress() {
		return address;
	}

	public java.io.InputStream getInputStream() {
		return istream;
	}

	public java.io.OutputStream getOutputStream() {
		return ostream;
	}

	public void teardown(boolean wait) {

	}

}