/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.thread;

/**
 * <p>Description: </p>
 * Incoming request handlers registry.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.huihoo.orbas.orb.ORB;
import org.huihoo.orbas.orb.protocols.Transport;

public class ServerWorkerRegistry implements java.lang.Runnable {

	ORB orb;

	/**
	 * @clientCardinality 1
	 */
	RequestQueue queue;
	boolean flag;

	/**
	 * @clientCardinality 1
	 * @directed
	 */
	private ThreadPool lnkThreadPool;

	public ServerWorkerRegistry(ORB orb) {
		this.orb = orb;
		queue = orb.getRequestQueue();
		flag = true;
	}

	public void run() {
		while (flag) {
			Transport transport;
			transport = (Transport) queue.removeFromQueue();

			if (transport == null) {
				System.out.println("ServerWorkerregistry:got null transport");
				continue;
			}

			java.lang.Thread t = new java.lang.Thread(
					orb.getDefaultServerWorker(transport));
			t.start();
		}
	}

	public void shutdown() {
		flag = false;
	}
}