/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.typecode;

/**
 * <p>Description: </p>
 * TypeCode for array.
 * <p>Copyright (c) 2002,2003</p>
 * <p>Company: <a href="http://www.huihoo.org/">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.omg.CORBA.TypeCode;

public class TypeCodeArray extends TypeCodeBase {

	int length;
	TypeCode elementType;

	public TypeCodeArray(int length, TypeCode element_type) {
		this.length = length;
		this.elementType = element_type;
	}

	public boolean equal(org.omg.CORBA.TypeCode tc) {
		if (tc.kind() != org.omg.CORBA.TCKind.tk_array)
			return false;

		TypeCodeArray tc1 = (TypeCodeArray) tc;
		if ((length == tc1.length) && (elementType.equal(tc1.elementType))) {
			return true;
		}

		return false;
	}

	public org.omg.CORBA.TypeCode get_compact_typecode() {
		return new TypeCodeArray(length, elementType.get_compact_typecode());
	}

	public org.omg.CORBA.TCKind kind() {
		return org.omg.CORBA.TCKind.tk_array;
	}

	public java.lang.String id() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public java.lang.String name() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int member_count() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public java.lang.String member_name(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode member_type(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.Any member_label(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode discriminator_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int default_index() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int length() throws org.omg.CORBA.TypeCodePackage.BadKind {
		return length;
	}

	public org.omg.CORBA.TypeCode content_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		return elementType;
	}

	public short fixed_digits() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short fixed_scale() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short member_visibility(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short type_modifier() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode concrete_base_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}
}
