/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.typecode;

/**
 * <p>
 * Description:
 * </p>
 * TypeCode base class.
 * <p>
 * Copyright (c) 2002,2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

public abstract class TypeCodeBase extends org.omg.CORBA.TypeCode {

	public boolean equivalent(org.omg.CORBA.TypeCode tc) {

		TypeCodeAlias tc1 = (TypeCodeAlias) tc;

		if (tc.kind() == org.omg.CORBA.TCKind.tk_alias) {

			try {
				org.omg.CORBA.TypeCode newTc = tc1.content_type();
				return equivalent(newTc);
			} catch (org.omg.CORBA.TypeCodePackage.BadKind ex) {
				return false;
			}
		}

		if (tc.kind() != kind()) {
			return false;
		}

		if (kind() == org.omg.CORBA.TCKind.tk_alias) {
			try {
				org.omg.CORBA.TypeCode newTc = tc1.content_type();
				return newTc.equivalent(tc);
			} catch (org.omg.CORBA.TypeCodePackage.BadKind ex) {
				return false;
			}
		}

		return equal(tc);
	}
}