/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.orb.typecode;

/**
 * <p>
 * Description:
 * </p>
 * TypeCode for enum.
 * <p>
 * Copyright (c) 2002,2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~mep">mep(mep@huihoo.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

// import org.omg.CORBA.*;

public class TypeCodeEnum extends TypeCodeBase {

	String id;
	String name;
	String[] members;

	public TypeCodeEnum(String id, String name, String[] members) {
		this.id = id;
		this.name = name;
		this.members = members;
	}

	public boolean equal(org.omg.CORBA.TypeCode tc) {
		if (tc.kind() != org.omg.CORBA.TCKind.tk_enum) {
			return false;
		}

		try {
			if (tc.id() == id) {
				return true;
			}

			TypeCodeEnum tc1 = (TypeCodeEnum) tc;

			if (members.length != tc1.members.length)
				return false;

			if ((name == tc1.name())) {
				for (int i = 0; i < members.length; ++i) {
					if (!members[i].equals(tc1.members[i])) {
						return false;
					}
				}

				return true;
			}
		} catch (org.omg.CORBA.TypeCodePackage.BadKind ex) {
			return false;
		}

		return true;
	}

	public org.omg.CORBA.TypeCode get_compact_typecode() {
		return new TypeCodeEnum(id, null, null);
	}

	public org.omg.CORBA.TCKind kind() {
		return org.omg.CORBA.TCKind.tk_enum;
	}

	public java.lang.String id() throws org.omg.CORBA.TypeCodePackage.BadKind {
		return id;
	}

	public java.lang.String name() throws org.omg.CORBA.TypeCodePackage.BadKind {
		return name;
	}

	public int member_count() throws org.omg.CORBA.TypeCodePackage.BadKind {
		if (members != null) {
			return members.length;
		} else {
			return 0;
		}
	}

	public java.lang.String member_name(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		if (members != null) {
			if (index < 0 || index >= members.length) {
				throw new org.omg.CORBA.TypeCodePackage.Bounds();
			}

			return members[index];
		} else {
			throw new org.omg.CORBA.TypeCodePackage.Bounds();
		}
	}

	public org.omg.CORBA.TypeCode member_type(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.Any member_label(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode discriminator_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int default_index() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public int length() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode content_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short fixed_digits() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short fixed_scale() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short member_visibility(int index)
			throws org.omg.CORBA.TypeCodePackage.BadKind,
			org.omg.CORBA.TypeCodePackage.Bounds {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public short type_modifier() throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}

	public org.omg.CORBA.TypeCode concrete_base_type()
			throws org.omg.CORBA.TypeCodePackage.BadKind {
		throw new org.omg.CORBA.TypeCodePackage.BadKind();
	}
}
