/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.poa;

/**
 * <p>Description: </p>
 * POAManager Implement of CORBA POA.
 * <p>Copyright (c) 2003</p>
 * <p>Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.State;

public class POAManagerImpl extends org.omg.CORBA.LocalObject implements
		POAManager {
	org.omg.PortableServer.POAManagerPackage.State state;

	public POAManagerImpl() {
		// the default poa manager is HOLDING
		state = org.omg.PortableServer.POAManagerPackage.State.HOLDING;
	}

	public synchronized void activate()
			throws org.omg.PortableServer.POAManagerPackage.AdapterInactive {
		// check state:
		// current state must not be "INACTIVE"
		if (this.state.value() == org.omg.PortableServer.POAManagerPackage.State._INACTIVE) {
			throw new org.omg.PortableServer.POAManagerPackage.AdapterInactive(
					"inactive state cannot change to active state");
		}
		//
		// change state to "active"
		this.state = org.omg.PortableServer.POAManagerPackage.State.ACTIVE;

	}

	public void hold_requests(boolean wait_for_completion)
			throws org.omg.PortableServer.POAManagerPackage.AdapterInactive {

		throw new java.lang.UnsupportedOperationException(
				"Minimum CORBA:Method hold_requests() not yet implemented.");
	}

	public void discard_requests(boolean wait_for_completion)
			throws org.omg.PortableServer.POAManagerPackage.AdapterInactive {

		throw new java.lang.UnsupportedOperationException(
				"Minimum CORBA:Method discard_requests() not yet implemented.");
	}

	public void deactivate(boolean etherealize_objects,
			boolean wait_for_completion)
			throws org.omg.PortableServer.POAManagerPackage.AdapterInactive {

		throw new java.lang.UnsupportedOperationException(
				"Minimum CORBA:Method deactivate() not yet implemented.");
	}

	public synchronized State get_state() {
		return state;
	}

}