/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.poa;

/**
 * <p>Description: </p>
 * Wrapper for request.
 * <p>Copyright (c) 2003</p>
 * <p>Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a></p>
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.Servant;

public class RequestEntry {
	// ~
	private String method_name;
	private InputStream inputStream;
	private ResponseHandler responseHandler;
	private Servant servant;
	private OutputStream outputStream;

	// ~
	public RequestEntry(Servant servant, String method_name,
			InputStream inputStream, ResponseHandler responseHandler) {
		this.servant = servant;
		this.method_name = method_name;
		this.inputStream = inputStream;
		this.responseHandler = responseHandler;
	}

	public String getMethodName() {
		return method_name;
	}

	public InputStream getInputStream() {
		return inputStream;
	}

	public ResponseHandler getResponseHandler() {
		return responseHandler;
	}

	public InvokeHandler getInvokeHandler() {
		return (InvokeHandler) servant;
	}

	public Servant getServant() {
		return (Servant) servant;
	}

	public OutputStream getOutputStream() {
		return this.outputStream;
	}

	public void setOutputStream(OutputStream out) {
		this.outputStream = out;
	}

}