/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.util;

/**
 * <p>
 * Description:
 * </p>
 * Interface for logger.
 * <p>
 * Copyright (c) 2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

public interface Logger {

	public void debug(Object msg);

	public void debug(Object msg, Throwable t);

	/**
	 * Log general info.
	 * 
	 * @param msg
	 *            Ojbect
	 * @param t
	 *            Throwable
	 */
	public void info(Object msg, Throwable t);

	public void info(Object msg);

	/**
	 * Log warnning info.
	 * 
	 * @param msg
	 *            Ojbect
	 * @param t
	 *            Throwable
	 */
	public void warn(Object msg, Throwable t);

	public void warn(Object msg);

	/**
	 * Log error info.
	 * 
	 * @param msg
	 *            Ojbect
	 * @param t
	 *            Throwable
	 */
	public void error(Object msg, Throwable t);

	public void error(Object msg);

	/**
	 * Log fatal error info.
	 * 
	 * @param msg
	 *            Ojbect
	 * @param t
	 *            Throwable
	 */
	public void fatal(Object msg, Throwable t);

	public void fatal(Object msg);

}