/* Orbas:
 *     A open source CORBA Specification implementation from Huihoo.
 *
 * Copyright 2002-2003 Huihoo.org, Inc. All Right Reserved.
 *
 * This software is licensed under LGPL license.
 * See terms of license at gnu.org.
 *
 * For more information, visit:
 *
 * http://www.huihoo.org/orbas
 */

package org.huihoo.orbas.util;

/**
 * <p>
 * Description:
 * </p>
 * Logger factory for get avaluable logger.
 * <p/>
 * The logger provide 5 types of message.
 * <p/>
 * info<br/>
 * debug<br/>
 * error<br/>
 * fatal<br/>
 * warn<br/>
 * <p/>
 * <b>Example:</b>
 * <p/>
 * 
 * <pre>
 *  //Get Logger tool.
 *   Logger logger = LoggerFactory.getLogger("My head msg");
 *   logger.debug("my debug msg");
 *   logger.debug("my exception",new MyException);
 * </pre>
 * <p/>
 * output display will be:
 * <p/>
 * [Debug-My head msg]my debug msg
 * <p/>
 * [Debug-My head msg]my exception<br/>
 * exception stack........<br/>
 * ...............<br/>
 * 
 * 
 * <p>
 * Copyright (c) 2003
 * </p>
 * <p>
 * Company: <a href="http://www.huihoo.org/orbas">huihoo.org</a>
 * </p>
 * 
 * @author <a href="http://www.huihoo.org/~cocia">Cocia Lin(cocia@163.com)</a>
 * @see <a href="http://www.huihoo.org/orbas">http://www.huihoo.org/orbas</a>
 * @version 1.0
 */

public class LoggerFactory {
	private LoggerFactory() {
	}

	private static java.util.Hashtable loggers = new java.util.Hashtable();

	public synchronized static Logger getLogger(String name) {
		Logger log = (Logger) loggers.get(name);
		if (log == null) {
			log = new CommonLogger(name);
			loggers.put(name, log);
		}
		//
		return log;
	}

}