package com.mobit.managers;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.util.Log;
import android.widget.EditText;

import com.mobit.takeout.R;

public class StaticCall {

	public static final String base_url = "http://10.0.2.2/";

	public StaticCall() {

	}

	/**
	 * Controls when the search icon is displayed
	 * 
	 * @param view
	 * @param hasFocus
	 */
	public static void showSearchIcon(EditText view, boolean hasFocus) {
		if (hasFocus) {
			view.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
		} else {
			view.setCompoundDrawablesWithIntrinsicBounds(
					R.drawable.ic_menu_search, 0, 0, 0);
		}
	}

	public static boolean checkNet(Activity activity) {
		boolean has_net = false;
		ConnectivityManager cM = (ConnectivityManager) activity
				.getApplicationContext().getSystemService(
						Context.CONNECTIVITY_SERVICE);
		android.net.NetworkInfo wifi = cM
				.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
		android.net.NetworkInfo mobile = cM
				.getNetworkInfo(ConnectivityManager.TYPE_MOBILE);

		if (wifi.isConnected() || mobile.isConnected()) {
			has_net = true;
		}

		return has_net;
	}

	public static Dialog getDialog(int d, final Activity activity) {
		AlertDialog ad = null;

		switch (d) {
		case 0:
			AlertDialog.Builder data_dialog = new AlertDialog.Builder(activity);
			data_dialog.setTitle("Internet Connection");
			data_dialog
					.setMessage("Please Enable Internet Connection to be able to use this service");
			data_dialog.setPositiveButton("OK",
					new DialogInterface.OnClickListener() {

						@Override
						public void onClick(DialogInterface dialog, int which) {
							try {
								Intent intent = new Intent(Intent.ACTION_MAIN);
								intent.setClassName("com.android.phone",
										"com.android.phone.Settings");
								activity.startActivity(intent);
							} catch (ActivityNotFoundException anfe) {
								Log.e("Activity Not Found", anfe.getMessage());
							}

						}
					});
			data_dialog.setNegativeButton("Cancel",
					new DialogInterface.OnClickListener() {

						@Override
						public void onClick(DialogInterface dialog, int which) {

						}
					});
			ad = data_dialog.create();
			break;
		}

		return ad;

	}
}
