package com.mobit.models;

import java.util.ArrayList;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.mobit.takeout.R;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;

public class RestaurantAdapter extends BaseAdapter {
	private DisplayImageOptions options;

	private ArrayList<Restaurant> restList;

	private LayoutInflater inflater;

	public RestaurantAdapter(Context context, ArrayList<Restaurant> restList) {
		this.restList = restList;
		inflater = LayoutInflater.from(context);
		options = new DisplayImageOptions.Builder()
				.showImageForEmptyUri(R.drawable.java_old_school)
				.showImageOnFail(R.drawable.java_old_school).build();

	}

	@Override
	public int getCount() {
		return restList.size();
	}

	@Override
	public Object getItem(int position) {
		return restList.get(position);
	}

	@Override
	public long getItemId(int position) {
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		ViewHolder holder;

		if (convertView == null) {
			convertView = inflater.inflate(R.layout.restaurant_list_item, null);

			holder = new ViewHolder();
			holder.name = (TextView) convertView
					.findViewById(R.id.txtv_rest_title);
			holder.slogan = (TextView) convertView
					.findViewById(R.id.txtv_rest_slogan);
			holder.location = (TextView) convertView
					.findViewById(R.id.txtv_rest_location);
			holder.logo = (ImageView) convertView
					.findViewById(R.id.img_rest_logo);

			convertView.setTag(holder);

		} else {
			holder = (ViewHolder) convertView.getTag();

		}

		Restaurant rest = restList.get(position);

		holder.name.setText(rest.getName());
		holder.slogan.setText(rest.getSlogan());
		holder.location.setText(rest.getLocation());

		if (holder.logo != null) {
			// load image into imageview using library
			ImageLoader.getInstance().displayImage(rest.getLogo(), holder.logo,
					options);
		}

		return convertView;
	}

	static class ViewHolder {
		TextView name;
		TextView slogan;
		TextView location;
		ImageView logo;

	}

}
