package com.mobit.takeout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.database.DataSetObserver;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v4.widget.DrawerLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.SimpleAdapter;
import android.widget.Toast;

import com.mobit.managers.DataSimulation;
import com.mobit.managers.JSONParser;
import com.mobit.managers.StaticCall;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;

/**
 * @author dnjoroge
 * 
 */
@SuppressLint("NewApi")
public class TakeoutMain extends Activity {

	// UI handler for thread UI updates
	Handler handler;
	// enclosure of the activity
	private DrawerLayout mDrawerLayout;

	// navigation drawer
	LinearLayout drawer_ll;

	// listview
	private ListView cat_list;

	// ActionBarDrawerToggle indicates the presence of Navigation Drawer in the
	// action bar
	private ActionBarDrawerToggle mDrawerToggle;

	// Drawer title
	private String mTitle = "";

	// Category Search Box
	EditText etxt_search_cat;

	// Search Category Button
	ImageButton btn_srch_cat;

	// Search Category Progress Bar
	ProgressBar pb_srch_cat;

	MenuFragment menuFragment;
	RestaurantFragment restFragment;

	@Override
	protected void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		init();
		startRestFragment("0", "Restaurants");

	}

	/**
	 * 
	 */
	/**
	 * 
	 */

	public void init() {
		/* Asynchronous Image Loading Library */
		ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(
				getApplicationContext())

		.build();

		ImageLoader.getInstance().init(config);
		handler = new Handler();

		mTitle = getResources().getString(R.string.app_name);

		getActionBar().setTitle(mTitle);

		// Getting reference to the views
		mDrawerLayout = (DrawerLayout) findViewById(R.id.drawer_layout);

		drawer_ll = (LinearLayout) findViewById(R.id.left_drawer);

		cat_list = (ListView) findViewById(R.id.drawer_list);

		etxt_search_cat = (EditText) findViewById(R.id.etxt_search_cat);

		btn_srch_cat = (ImageButton) findViewById(R.id.btn_srch_cat);

		pb_srch_cat = (ProgressBar) findViewById(R.id.pb_categories);

		menuFragment = new MenuFragment();
		restFragment = new RestaurantFragment();

		StaticCall.showSearchIcon(etxt_search_cat, false);

		etxt_search_cat.addTextChangedListener(new TextWatcher() {

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,
					int after) {
				// TODO Auto-generated method stub

			}

			@Override
			public void onTextChanged(CharSequence s, int start, int before,
					int count) {
				// TODO Auto-generated method stub

			}

			@Override
			public void afterTextChanged(Editable s) {
				if (etxt_search_cat.getText().toString().length() == 0) {
					btn_srch_cat.setVisibility(View.GONE);
					StaticCall.showSearchIcon(etxt_search_cat, false);
				} else {
					btn_srch_cat.setVisibility(View.VISIBLE);
					StaticCall.showSearchIcon(etxt_search_cat, true);
				}

			}
		});

		// Getting reference to the ActionBarDrawerToggle
		mDrawerToggle = new ActionBarDrawerToggle(this, mDrawerLayout,
				R.drawable.ic_drawer, R.string.drawer_open,
				R.string.drawer_close) {

			/** Called when drawer is closed */
			public void onDrawerClosed(View view) {

				invalidateOptionsMenu();

			}

			/** Called when a drawer is opened */
			public void onDrawerOpened(View drawerView) {
				invalidateOptionsMenu();
			}

		};

		// Setting DrawerToggle on DrawerLayout
		mDrawerLayout.setDrawerListener(mDrawerToggle);

		// Enabling Home button
		getActionBar().setHomeButtonEnabled(true);

		// Enabling Up navigation
		getActionBar().setDisplayHomeAsUpEnabled(true);

		// background
		getActionBar().setBackgroundDrawable(
				getResources().getDrawable(R.drawable.title_background));

		// / Setting item click listener for the listview cat_list
		cat_list.setOnItemClickListener(new OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> parent, View view,
					int position, long id) {

				/* get item and start a fragment with the appropriate arguments */
				@SuppressWarnings("unchecked")
				HashMap<String, String> map = (HashMap<String, String>) cat_list
						.getItemAtPosition(position);

				startRestFragment(map.get("cat_id"), map.get("cat_name"));

				// Closing the drawer
				mDrawerLayout.closeDrawer(drawer_ll);

			}

		});

		cat_list.setVisibility(View.GONE);
		pb_srch_cat.setVisibility(View.VISIBLE);
		fetchCategories("ALL");

	}

	private void startRestFragment(String cat_id, String cat_name) {
		Bundle b = new Bundle();

		b.putString("cat_id", cat_id);
		b.putString("cat_name", cat_name);

		restFragment = new RestaurantFragment();
		restFragment.setArguments(b);

		FragmentManager fm = getFragmentManager();
		FragmentTransaction ft = fm.beginTransaction();
		ft.replace(R.id.content_frame, restFragment);
		ft.commit();
	}

	/**
	 * Fetch Categories from server passing string from search text box as the
	 * param
	 * 
	 * @param param
	 */
	public void fetchCategories(final String param) {
		boolean has_net = StaticCall.checkNet(this);

		if (has_net) {
			new Thread(new Runnable() {
				@Override
				public void run() {

					Looper.prepare();
					try {
						final ArrayList<HashMap<String, String>> cats_list = new ArrayList<HashMap<String, String>>();
						List<NameValuePair> params = new ArrayList<NameValuePair>();
						JSONParser parser = new JSONParser();
						boolean hasList = false;

						BasicNameValuePair cat_name = new BasicNameValuePair(
								"cat_name", param);

						params.add(cat_name);

						/*
						 * JSONObject jo_cats = parser.makeHttpRequest(
						 * StaticCall.base_url, "POST", params);
						 */

						JSONObject jo_cats = DataSimulation.getCategories();

						if (jo_cats != null) {
							hasList = true;

							JSONArray ja_cat = jo_cats
									.getJSONArray("categories");

							if (ja_cat != null) {
								hasList = true;

								for (int i = 0; i < ja_cat.length(); i++) {
									JSONObject jo_cat = ja_cat.getJSONObject(i);

									if (jo_cat != null) {
										hasList = true;
										HashMap<String, String> cat_map = new HashMap<String, String>();

										cat_map.put("cat_id",
												jo_cat.getString("cat_id"));
										cat_map.put("cat_name",
												jo_cat.getString("cat_name"));

										cats_list.add(cat_map);
									} else {
										hasList = false;
									}
								}
							} else {
								hasList = false;
							}

						} else {
							hasList = false;
						}

						if (hasList) {
							/* populate the list of categories */

							handler.post(new Runnable() {
								@Override
								public void run() {
									showCategories(cats_list);
								}
							});

						} else {
							/* show error */
						}
					} catch (JSONException je) {
						Log.e("Categories Fetch Error", je.toString());
					}
				}
			}, "fetchCategories").start();
		} else {
			StaticCall.getDialog(0, this).show();
		}

	}

	/**
	 * @param cat_list_map
	 */
	public void showCategories(ArrayList<HashMap<String, String>> cat_list_map) {
		final ListAdapter adapter = new SimpleAdapter(this, cat_list_map,
				R.layout.drawer_list_item, new String[] { "cat_name" },
				new int[] { R.id.txtv_cat_li });

		cat_list.setVisibility(View.VISIBLE);
		pb_srch_cat.setVisibility(View.GONE);
		etxt_search_cat.setEnabled(true);
		cat_list.setTranscriptMode(AbsListView.TRANSCRIPT_MODE_ALWAYS_SCROLL);
		cat_list.setAdapter(adapter);
		cat_list.setTextFilterEnabled(true);
		adapter.registerDataSetObserver(new DataSetObserver() {
			@Override
			public void onChanged() {
				super.onChanged();
				cat_list.setSelection(adapter.getCount() - 1);
			}
		});
	}

	public void onViewClicked(View view) {
		switch (view.getId()) {
		case R.id.btn_srch_cat:
			Toast.makeText(TakeoutMain.this, "Searching...", Toast.LENGTH_LONG)
					.show();
			cat_list.setVisibility(View.GONE);
			pb_srch_cat.setVisibility(View.VISIBLE);
			etxt_search_cat.setEnabled(false);
			/*
			 * start searching categories
			 */
			fetchCategories(etxt_search_cat.getText().toString().trim());
			etxt_search_cat.setText("");

			break;

		case R.id.btn_srch_rest:
			restFragment.onViewClicked(view);
			break;
		case R.id.btn_call:
			menuFragment.onViewClicked(view);
			break;

		}

	}

	public MenuFragment getMenuFragment() {
		return menuFragment;
	}

	public void setMenuFragment(MenuFragment menuFragment) {
		this.menuFragment = menuFragment;
	}

	public RestaurantFragment getRestFragment() {
		return restFragment;
	}

	public void setRestFragment(RestaurantFragment restFragment) {
		this.restFragment = restFragment;
	}

	@Override
	protected void onPostCreate(Bundle savedInstanceState) {
		super.onPostCreate(savedInstanceState);
		mDrawerToggle.syncState();
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if (mDrawerToggle.onOptionsItemSelected(item)) {
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

	/** Called whenever we call invalidateOptionsMenu() */
	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		// If the drawer is open, hide action items related to the content view
		boolean drawerOpen = mDrawerLayout.isDrawerOpen(drawer_ll);

		menu.findItem(R.id.action_settings).setVisible(!drawerOpen);
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
}
