/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ClientSide;

import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Timer;
import java.util.Vector;
import java.util.jar.JarFile;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

import BothSide.EntityInfo;
import BothSide.Constants.EntityType;

import map.maps.MapPaths;



/**
 *
 * @author iamdelac
 */
public class RemotePlayer extends javax.swing.JLabel{

	protected final String STAND="player/stand/";
	protected final String WALK="player/walk/";
	protected final String ATTACK="player/attack/";
	protected final String LOOKING="player/looking/";
    private String nome_player;
    private Vector <javax.swing.ImageIcon[]> sprites;
    protected String stato;
    protected String orientation;
    protected RemotePlayer nemicoFocused;
    protected int  offset_x;
    protected int  offset_y;
    protected  javax.swing.JLabel nick;
    protected EntityType entityType;
    String statoOld;
    int currentFrame;
    boolean oneCycle;



    public void setNome(String nome){
    	nome_player=nome;
    	if (entityType.equals(EntityType.PLAYER))
    		{
    		 nick.setVisible(true);
    		}
    	else{nick.setVisible(false);}
    	nick.setText(nome);
    }
 
    public RemotePlayer (String nome_player, EntityType entityType ) {
       super();
       currentFrame=0;
       this.nome_player = nome_player;
       this.entityType = entityType;
       nick=new JLabel();
       nick.setText(nome_player);
       nick.setSize(nome_player.length()*10, 10);
       nick.setForeground(Color.GREEN);
       sprites = new Vector<ImageIcon[]>();
       this.setDoubleBuffered(true);       
       this.orientation = "n/";
       stato = STAND;
        statoOld = stato;
        oneCycle = false;
        cambiaAnimazione(STAND);
       final RemotePlayer this_instance = this;
       addMouseListener(new java.awt.event.MouseAdapter() {
           public void mousePressed(java.awt.event.MouseEvent evt)
           {
             System.out.println("richiesta attacco");
             Client.instance.mainForm.getMainPlayer().attacca(this_instance);
           }
         });
       addContainerListener(new java.awt.event.ContainerAdapter() { 
           public void componentRemoved(java.awt.event.ContainerEvent evt) {
               nick.getParent().remove(nick);
           }
       });
       }


 
       
    
public void cambiaAnimazione(String animazione){
        offset_x = 46; // devono puntare ai piedi
        offset_y = 74;
        if (animazione.contains("asino"))
        	{
        	offset_x = 60; 
            offset_y = 33;
        	}
	Vector <javax.swing.ImageIcon[]> sprites_temp = new Vector <javax.swing.ImageIcon[]>();
    Vector <String> nomiFile=new Vector<String>();
   try{
    JarFile jarfile = new JarFile(System.getProperty("java.class.path"));
    Enumeration em = jarfile.entries();
    for (Enumeration em1 = jarfile.entries(); em1.hasMoreElements();) {
      Object elem = em1.nextElement();
      if ((""+elem).contains(stato+orientation) && ((""+elem).contains("jpg")||(""+elem).contains("gif")||(""+elem).contains("png")))
   	   {            	   
   	   String[] path =(""+elem).split("/");
   	   nomiFile.add(path[path.length-1]);
   	   }
    }
  
    
    for (String nomeFile : nomiFile) 
    {
     javax.swing.ImageIcon[] orientations = new javax.swing.ImageIcon[8];
	orientations[0] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"n/"+nomeFile));
	orientations[1] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"ne/"+nomeFile));
	orientations[2] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"e/"+nomeFile));
	orientations[3] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"se/"+nomeFile));
	orientations[4] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"s/"+nomeFile));
	orientations[5] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"sw/"+nomeFile));
	orientations[6] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"w/"+nomeFile));
	orientations[7] = new javax.swing.ImageIcon(getClass().getResource("/"+stato+"nw/"+nomeFile));
	sprites_temp.add(orientations);
      sprites = sprites_temp;
    }
   setSize(sprites_temp.get(0)[0].getIconWidth(), sprites.get(0)[0].getIconHeight());
   }
   catch(Exception ze){
     ze.printStackTrace();
     //System.exit(0);
   }

}




public void setStato(String stato){
	this.stato=stato;
}

public void setOrientation(String or)
	{
	 orientation=or;
	}
        



protected void updateIcon(){
     try{
     if ( currentFrame>=sprites.size())
        {currentFrame=0;}
     ImageIcon sprite;
     if (!statoOld.equals(stato))
         {
          statoOld = stato;
          cambiaAnimazione(stato);
          currentFrame=0;
         }
     if (orientation.equals("n/")) 		 {this.setIcon(sprites.get(currentFrame)[0]);}
     else{if (orientation.equals("ne/")) {this.setIcon(sprites.get(currentFrame)[1]);}
     else{if (orientation.equals("e/"))  {this.setIcon(sprites.get(currentFrame)[2]);}
     else{if (orientation.equals("se/")) {this.setIcon(sprites.get(currentFrame)[3]);}
     else{if (orientation.equals("s/"))  {this.setIcon(sprites.get(currentFrame)[4]);}
     else{if (orientation.equals("sw/")) {this.setIcon(sprites.get(currentFrame)[5]);}
     else{if (orientation.equals("w/"))  {this.setIcon(sprites.get(currentFrame)[6]);}
     else{if (orientation.equals("nw/")) {this.setIcon(sprites.get(currentFrame)[7]);}}}}}}}}          
     if (oneCycle)
      {
       oneCycle = false;
       if (stato.equals(ATTACK) || stato.equals(LOOKING))
         {stato=STAND;}
      }
     if (statoOld.equals(ATTACK) || statoOld.equals(LOOKING))
      {
       oneCycle = true;
      }
     currentFrame++;
     }catch(Exception ex){ex.printStackTrace();}
}

@Override
public void setLocation(Point p){
	nick.setLocation(new Point(p.x-20,p.y+5));
    p.x = p.x - offset_x;
    p.y = p.y - offset_y;
   super.setLocation(p);
}
 @Override
public void setLocation(int x , int y){
	nick.setLocation(new Point(x-20,y+5));	 
    x = x - offset_x;
    y = y - offset_y;
   super.setLocation(x,y);
}

 @Override
 public Point getLocation(){ 
     return new Point (super.getLocation().x+offset_x,super.getLocation().y+offset_y);
 }

public String getNome() {
	return nome_player;
}

    
       
}
