package ServerSide;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;

import BothSide.Constants.EntityType;
import BothSide.EntityInfo;
import ClientSide.RemoteListener;

public class ServicesImpl extends UnicastRemoteObject implements ServicesInterface
{
	 private Vector<RemoteListener> listeners = new Vector<RemoteListener>();

        public ServicesImpl(String name) throws RemoteException
                {
                super();
                try
                        {
                        Naming.rebind(name, this);
                        }
                catch(Exception e)   {e.printStackTrace();}
                }
        
        
        public Vector<EntityInfo> getRemotePlayersInfo()
                {
        	     return Server.instance.getPlayerList();
                }
        
        

        public synchronized void setPlayerInfo(EntityInfo info) throws RemoteException {
        	/*synchronized (Server.class)*/ {
        	for (EntityInfo nf:Server.instance.getPlayerList()){
        		if (nf.nome.equals(info.nome))
        			{
        			 nf.stato = info.stato;//stato
        			 nf.orientation = info.orientation;//orientation
        			 nf.location = info.location;
        			 
        			}
        	    }
        	}
		}


		public void bornPlayer(EntityInfo info) throws RemoteException {
			info.puntoAttacco=null;
			Server.instance.addPlayer(info);
		}


		public void killPlayer(String nomePlayer) throws RemoteException {
			Server.instance.removePlayer(nomePlayer);			
		}


		@Override
		public String leggiOstacoli() throws RemoteException {
		        String ostacoli = "";
		        try{
		            new File((getClass().getResource("/map/maps/bk.jpg").getFile()).replaceAll("jpg", "txt")).createNewFile();
		            String fileName  = (getClass().getResource("/map/maps/bk.jpg").getFile()).replaceAll("jpg", "txt");
		            FileReader inputFileReader   = new FileReader(fileName);
		            BufferedReader inputStream   = new BufferedReader(inputFileReader);
		            ostacoli = inputStream.readLine();
		            inputStream.close();
		            }
		        catch(Exception ex){ex.printStackTrace();}
		        return ostacoli;
		}


		@Override
		public void assegnaColpo(String nomePlayer, Point p) throws RemoteException {
			for (EntityInfo nf:Server.instance.getPlayerList()){
        		if (nf.nome.equals(nomePlayer))
        			{
        			 nf.puntoAttacco = p;        			
        			}
        	}
		}
		
		@Override
		public void colpoRicevuto(String nomePlayer) throws RemoteException {
			for (EntityInfo nf:Server.instance.getPlayerList()){
        		if (nf.nome.equals(nomePlayer))
        			{
        			 nf.puntoAttacco=null;
        			}
        	}
		}
		

		  
		   

		    public void addListener (RemoteListener listener)  throws RemoteException
		      {
		        listeners.addElement(listener);
		      }

		    
		    public void removeListener (RemoteListener listener) throws RemoteException
		      {
		        listeners.removeElement(listener);
		      }
		    

		    public void setPlayersInfo ()
		      {
		        Vector<RemoteListener> clonedList = (Vector<RemoteListener>)listeners.clone();
		        for (Enumeration e = clonedList.elements(); e.hasMoreElements(); )
		          {
		            RemoteListener l = (RemoteListener)e.nextElement();
		            try
		              {
		                setPlayerInfo(l.getRemotePlayerInfo());
		              }
		            catch (RemoteException ee)
		             {listeners.remove(l); System.out.println(" stato rimosso un client");}
		          }
		      }
}