package ClientSide;

import java.awt.Point;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

import javax.swing.JOptionPane;

import BothSide.Constants.EntityType;
import BothSide.EntityInfo;
import ServerSide.ServicesInterface;


public class Client extends UnicastRemoteObject implements ServicesClient{
	 MainForm mainForm;
	 Player player;
	 ServicesInterface myServerObject;
	 EntityInfo info;
	 private Vector<GraphicalEntity> remotePlayerList;	 
	 static protected Client instance;
	 private Perform_setLayer azione_setLayer;
	 public SpritesList allSprites;
	 
	 
	
	 
	 public String getNomeLocalPlayer(){
		 return player.nome_player;
	 }
	 
	 
	public Client() throws RemoteException{
		super();
		this.allSprites = new SpritesList();
		this.remotePlayerList = new Vector<GraphicalEntity>();
		instance=this;
		info = new EntityInfo();
	}
	
	public static void main(String[]args)
	{
		
		Client c;
		try {
			c = new Client();
			c.run();
			//javax.media.Player player = Manager.createPlayer(new URL ("file:///Users/DeLac/Desktop/Dragon Age Leliana Song.mp2"));
			//player.start(); 
		} catch (Exception e) {e.printStackTrace();}
	}
	
	
	
	
	public  void run() {
	    final String serverName=JOptionPane.showInputDialog("ip server");
		
	    final String nome=JOptionPane.showInputDialog("scegli nome");
		
    	System.setProperty("java.security.policy","http://dl.dropbox.com/u/13520648/wideopen.policy");
    	if (System.getSecurityManager() == null)
    	  {System.setSecurityManager(new RMISecurityManager());}
		
		
		
		try {
			// bind server object to object in client
			System.out.println("connessione in corso...");
			myServerObject = (ServicesInterface) Naming.lookup("//" + serverName + "/RMIimpl");
			System.out.println("connesso");
			new Thread(new Runnable() {
				public void run() {					
					player = new Player(nome, EntityType.PLAYER);
					mainForm = new MainForm(player);
					mainForm.setVisible(true);
					aggiornaInfo();
					try {
						myServerObject.bornPlayer(info);
					} catch (RemoteException e) {
						e.printStackTrace();
					}
				}
			}).start();
			while( mainForm==null)
			  {
				Thread.sleep(2000);// gli do il tempo di creare il pupazzo
			  }
			myServerObject.addListener(this);
			new Perform_updateRemotePlayers().start();
			new Perform_drawGraphicalEntity().start();
			azione_setLayer = new Perform_setLayer();
		    azione_setLayer.start();
		} 
		catch (Exception e) {
			System.out.println("CLIENT Exception occured: " + e);
			e.printStackTrace();
			System.exit(0);
		}
		System.out.println("RMI connection successful");
	}

	
	
	public  void disconnetti(){
		try {
			myServerObject.killPlayer(info.nome);
			System.out.println(info.nome+" disconnesso");
		} catch (RemoteException e) {
			e.printStackTrace();
		}		
	}
	
	public void assegnaColpoToNemico(String nemico, Point p)
	{
		try {System.out.println("assegna colpo al nemico");
			myServerObject.assegnaColpoToNemico(nemico, p);
			
		} catch (RemoteException e) {e.printStackTrace();}
		System.out.println("fatto");
	}
	
	
	public void scalaEnergia(String nomeRemotePlayer, int hittedValue)
	{
	 	Vector<GraphicalEntity> clonedList = (Vector<GraphicalEntity>) remotePlayerList.clone();
	 	for(int i=0; i<clonedList.size();i++)
	 		{
	 		 if (clonedList.get(i).getNome().equals(nomeRemotePlayer))
	 		 	{
	 			 remotePlayerList.get(i).setHitted(hittedValue);
	 			 break;
	 		 	}
	 		}
	}
	
	public void riceviColpo( Point colpo)
	{
		player.riceviColpo(colpo);
	}
	
	public  void aggiornaInfo(){
		info.nome = mainForm.getMainPlayer().nome_player;
		info.stato = mainForm.getMainPlayer().stato;
		info.orientation = mainForm.getMainPlayer().orientation;
	    info.location = mainForm.getMainPlayer().getLocation();
	    info.entityType = EntityType.PLAYER;
	    info.spriteName = "player";
	}
	
	public String leggiOstacoli(){
		try {
			return(myServerObject.leggiOstacoli());
		} catch (RemoteException e) {
			e.printStackTrace();
			return null;
		}
	        
	}
	
	
	private class Perform_updateRemotePlayers extends Thread{
		
		public void run(){
			this.setName("azione_updateRemotePlayers");
			while(true){
			  try{
				  Vector<EntityInfo> infos;
				  infos = myServerObject.getRemotePlayersInfo();
				 int size =  remotePlayerList.size();				 
				 int toAdd = infos.size()-(size+1);
				 if (toAdd > 0)
					{
					 for (int h=0; h<infos.size();h++)
						{
						 boolean add=true;
						 for (int j=0; j<remotePlayerList.size();j++)
						  {
						   if (remotePlayerList.get(j).getNome().equals(infos.get(h).nome))
						    {
							   add=false;break;
						    }
						  }
						 if (add && !infos.get(h).nome.equals(info.nome))
						 	{
							 System.out.println("ho aggiunto "+infos.get(h).nome);
							 GraphicalEntity rp = new GraphicalEntity(infos.get(h).nome, infos.get(h).entityType, "player");
							 remotePlayerList.add(rp);
							 player.getParent().add(rp);	
							 player.getParent().add(rp.nick);
						 	}
						}
					}
				int toRemove = ((size+1))-infos.size();
				if (toRemove > 0)
					{
						 boolean remove;
						 for (int k=0; k<remotePlayerList.size();k++)
						  {
						   remove=true;
						   for (int z=0; z<infos.size();z++)
							{
						     if (infos.get(z).nome.equals(remotePlayerList.get(k).getNome()))
						 	 {
						      remove=false;
						      break;
						 	 }
						    }
						   if (remove)
						    {
							 if(player.nemicoFocused!=null && player.nemicoFocused.getNome().equals(remotePlayerList.get(k).getNome()))
							 	{
								 player.nemicoFocused=null;
							 	}
							 remotePlayerList.get(k).setVisible(false);
							 System.out.println("ho rimosso "+remotePlayerList.get(k).getNome());
							 player.getParent().remove(remotePlayerList.remove(k));
						    }
						  }
						
					}
				 int j=0;
				 int i=0;
				 GraphicalEntity temp;	
				 while( i<infos.size())
				  {
					if( ! infos.get(i).nome.equals(player.nome_player))
					  {
					   temp = remotePlayerList.get(j);
					   temp.entityType = infos.get(i).entityType; //deve essere la prima cosa che aggiorno, se non mi sbaglia il controllo se  player o nemico per il nick
					   temp.setNome(infos.get(i).nome) ;			   
					   temp.stato = infos.get(i).stato; 
					   temp.orientation = infos.get(i).orientation;
					   temp.nomeSprite = infos.get(i).spriteName;
					   temp.setLocation(infos.get(i).location);
					   j++;
					  }
					i++;
				 }	
				 Thread.sleep(18);
				}catch(Exception ex){System.out.println("client synch problems");ex.printStackTrace();}
				//synchronized(azione_setLayer){azione_setLayer.notify();}
			 }
			}
		
		
		
	}
		

	
private class Perform_setLayer extends Thread{
	public void run(){
		this.setName("azione_setLayer");
		while(true)
		{
		 synchronized (this) {try{wait();}catch(InterruptedException ex){return;}}
		 Vector<GraphicalEntity> clonedList = (Vector<GraphicalEntity>) remotePlayerList.clone();
		 for (int i=0; i<clonedList.size()-1;i++)
		 	{
			 for (int j=i; j<clonedList.size();j++)
			 	{
				 if (clonedList.get(i).getLocation().y > clonedList.get(j).getLocation().y)
				   {
					 GraphicalEntity temp = clonedList.get(i);
					 clonedList.set(i, clonedList.get(j));
					 clonedList.set(j, temp);
				   }
			 	}
		 	}
		 for (int i=0; i<remotePlayerList.size(); i++)
		  {
			if (player.stato.contains("die"))
				{
				remotePlayerList.get(i).getParent().setComponentZOrder(player,0); 
				}
			else
			    {
				remotePlayerList.get(i).getParent().setComponentZOrder(player, i);
				} 
		  }
		}
	}
}
	
	
	
		private class Perform_drawGraphicalEntity extends Thread{
			public void run(){
				this.setName("azione_drawGraphicalEntity");
			 while(true)
			  {
			   for (int i=0; i<remotePlayerList.size();i++)
			    {		
				 remotePlayerList.get(i).updateIcon();
				}
			   try{Thread.sleep(110);}catch(Exception ex){ex.printStackTrace();}			
			   }
			}
		}


		@Override
		public EntityInfo getRemotePlayerInfo() throws RemoteException {
			EntityInfo info = new EntityInfo();
			info.nome = instance.player.nome_player;
			info.location = instance.player.getLocation();
			info.orientation = instance.player.orientation;
			info.stato = instance.player.stato;
			info.entityType = EntityType.PLAYER;
			info.spriteName = "player";
			return info;
		}


		@Override
		public void receiveMessage(String player, String message)
				throws RemoteException {
			Vector<GraphicalEntity> clonedList = (Vector<GraphicalEntity>) remotePlayerList.clone();
		 	for(int i=0; i<clonedList.size();i++)
		 		{
		 		 if (clonedList.get(i).getNome().equals(player))
		 		 	{
		 			 remotePlayerList.get(i).talk(message);
		 			 break;
		 		 	}
		 		}
		}
		
		
	
	
}