package ClientSide;

import java.util.Vector;

import Animals.Cow_brown;
import Enemies.Skeleton;

public class SpritesList {
	
	private Vector<AnimationsSprites> sprites = new Vector<AnimationsSprites>(); 

	
	public  Vector<javax.swing.ImageIcon>[] getSprites (String nomeSprite, String stato)
	{
		stato = stato.split("/")[1];
		for (AnimationsSprites s : sprites)
	 	 {
		  if (s.nomeSprite.equals(nomeSprite))
		  	{
			  return s.getSprites(stato);
		  	}
		 }
		sprites.add(new AnimationsSprites(nomeSprite));
		return getSprites(nomeSprite, "nomeSprite/"+stato+"/");
		
		
	}
	

	
	
private class AnimationsSprites {
	private Vector<OrientedSprites> animationsSprites;
	public String nomeSprite;
	
	public AnimationsSprites(String nomeSprite){
		this.nomeSprite = nomeSprite;
		animationsSprites = new Vector<OrientedSprites>();
		caricaSprites();
	}
	
	private void caricaSprites()
	 {
		animationsSprites.add(new OrientedSprites("walk", nomeSprite));
		animationsSprites.add(new OrientedSprites("die", nomeSprite));
		animationsSprites.add(new OrientedSprites("attack", nomeSprite));
		animationsSprites.add(new OrientedSprites("looking", nomeSprite));
		animationsSprites.add(new OrientedSprites("stand", nomeSprite));
		animationsSprites.add(new OrientedSprites("hitted", nomeSprite));
	 }
	
	public Vector<javax.swing.ImageIcon>[] getSprites (String stato)
		{
		 for (OrientedSprites s : animationsSprites)
		 	{
			 if (s.stato.equals(stato))
			 	{
				return s.orientedSprites;
			 	}
		 	}
		 System.err.println("stato inesistente: "+stato);
		 System.exit(0);
		 return null;
		}
	
}
	
	
private class OrientedSprites {
	private Vector<javax.swing.ImageIcon>[] orientedSprites;
	public String stato;
	public String nomeSprite;
	
	public OrientedSprites(String stato, String nomeSprite){
		this.nomeSprite = nomeSprite;
		orientedSprites = new Vector[8];
		orientedSprites[0]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[1]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[2]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[3]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[4]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[5]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[6]=new Vector<javax.swing.ImageIcon>();
		orientedSprites[7]=new Vector<javax.swing.ImageIcon>();
		this.stato = stato;
		caricaSprites();
	}
	
	private void caricaSprites(){
		  int size = getSize(nomeSprite, stato);
		  String extension = getExtension(nomeSprite, stato);
		  for (int i=0; i<size; i++)
		    {
		     javax.swing.ImageIcon[] orientations = new javax.swing.ImageIcon[8];
		     orientedSprites[0].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/n/"+i+"."+extension)));
		     orientedSprites[1].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/ne/"+i+"."+extension)));
		     orientedSprites[2].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/e/"+i+"."+extension)));
		     orientedSprites[3].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/se/"+i+"."+extension)));
		     orientedSprites[4].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/s/"+i+"."+extension)));
		     orientedSprites[5].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/sw/"+i+"."+extension)));
		     orientedSprites[6].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/w/"+i+"."+extension)));
		     orientedSprites[7].add(new javax.swing.ImageIcon(getClass().getResource("/"+nomeSprite+"/"+stato+"/nw/"+i+"."+extension)));
		    }

	}
	
	
}


private int getSize(String animazione, String stato){
	if (animazione.equals("player"))
		{
		 if (stato.contains("stand"))
		 	{return Skeleton.stand_size;}
		 else if (stato.contains("walk"))
		 	{return Skeleton.walk_size;}
		 else if (stato.contains("looking"))
		 	{return Skeleton.looking_size;}
		 else if (stato.contains("die"))
		 	{return Skeleton.die_size;}
		 else if (stato.contains("hitted"))
		 	{return Skeleton.hitted_size;}
		 else if (stato.contains("attack"))
		 	{return Skeleton.attack_size;}
		}
	else if (animazione.equals("asino"))
		{  
		if (stato.contains("stand"))
	 	{return Cow_brown.stand_size;}
	 else if (stato.contains("walk"))
	 	{return Cow_brown.walk_size;}
	 else if (stato.contains("looking"))
	 	{return Cow_brown.looking_size;}
	 else if (stato.contains("die"))
	 	{return Cow_brown.die_size;}
	 else if (stato.contains("hitted"))
	 	{return Cow_brown.hitted_size;}
	 else if (stato.contains("attack"))
	 	{return Cow_brown.attack_size;}
		}
	return -1;
}

private String getExtension(String animazione, String stato){
	if (animazione.equals("player"))
	{
	 if (stato.contains("stand"))
	 	{return Skeleton.stand_extension;}
	 else if (stato.contains("walk"))
	 	{return Skeleton.walk_extension;}
	 else if (stato.contains("looking"))
	 	{return Skeleton.looking_extension;}
	 else if (stato.contains("die"))
	 	{return Skeleton.die_extension;}
	 else if (stato.contains("hitted"))
	 	{return Skeleton.hitted_extension;}
	 else if (stato.contains("attack"))
	 	{return Skeleton.attack_extension;}
	}
else if (animazione.equals("asino"))
	{  
	if (stato.contains("stand"))
 	{return Cow_brown.stand_extension;}
 else if (stato.contains("walk"))
 	{return Cow_brown.walk_extension;}
 else if (stato.contains("looking"))
 	{return Cow_brown.looking_extension;}
 else if (stato.contains("die"))
 	{return Cow_brown.die_extension;}
 else if (stato.contains("hitted"))
 	{return Cow_brown.hitted_extension;}
 else if (stato.contains("attack"))
	{return Cow_brown.attack_extension;}
	}
	System.exit(0);
	return "";
	
}
	
	
	
}
