package ServerSide;


import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Vector;

import map.maps.MapPaths;
import Animals.Cow_brown;
import BothSide.Constants.EntityType;
import BothSide.EntityInfo;
import Enemies.Skeleton;

public class Server
{
	 private Vector<EntityInfo> playerList;
	 Vector<CPUentity> nemici;
	 protected static Server instance;
	 protected  ServicesImpl impl;
	 protected  MapPaths map;
	 Perform_aggiornaPlayers aggiornaPlayers;
	 Perform_sorveglia sorveglia;
	 
	 
	 public Vector<EntityInfo> getPlayerList(){
		/*synchronized (playerList)*/ { return (Vector<EntityInfo>) playerList.clone();}
		}
	 
	  public static void main (String[] args){
		  Server s=new Server();
		  s.nemici=new Vector<CPUentity>();
		  s.instance = s;
		  s.run();
	  }
	 
	
	  private void creaNemici(){
		  Skeleton n = new Skeleton("nemico_"+nemici.size()+"");
		  n.start();
		  nemici.add(n);
         try {
        	 //uso il riferimento per indirizzo per le info dei nemici, cos non devo aggiornarle a mano nella lista
			impl.bornPlayer(n.info);
		} catch (RemoteException e) {
			e.printStackTrace();
		}
	  }
	  
	  private void creaAnimali(){
		  Cow_brown n = new Cow_brown("nemico_"+nemici.size()+"");
		  n.start();
		  nemici.add(n);
         try {
        	 //uso il riferimento per indirizzo per le info dei nemici, cos non devo aggiornarle a mano nella lista
			impl.bornPlayer(n.info);
		} catch (RemoteException e) {
			e.printStackTrace();
		}
	  }
	  
	  
	  
	  
	  
	  
        public void run()
                {        	
        	    playerList = new Vector<EntityInfo>();
        	    try
                   {
               	
        	    	
        	    	/**If you do start the rmiregistry after set codebase, and it can find your stub classes in CLASSPATH, 
        	    	 * it will not remember that the loaded stub class can be loaded from your server's code base, 
        	    	 * specified by the java.rmi.server.codebase property when you started up your server application. 
        	    	 * Therefore, the rmiregistry will not convey to clients the true code base associated with the stub class and, 
        	    	 * consequently, your clients will not be able to locate and to load the stub class or other server-side classes. 
        	    	 */
        	    	///System.setProperty("java.rmi.server.hostname", "87.20.66.90");
        	    	LocateRegistry.createRegistry(1099);
        	    	System.setProperty("java.security.policy","http://dl.dropbox.com/u/13520648/wideopen.policy");
        	    	System.setProperty("java.rmi.server.codebase","http://dl.dropbox.com/u/13520648/");
        	    	System.setProperty("java.net.preferIPv4Stack", "true");
        	    	System.out.println(System.getProperty("java.rmi.server.codebase"));
        	    	System.out.println(System.getProperty("java.security.policy")); 
        	    	if (System.getSecurityManager() == null)
            	    	System.setSecurityManager(new RMISecurityManager());
                		Thread.sleep(2000);
                        impl = new ServicesImpl("RMIimpl");
                        final Registry registry = LocateRegistry.getRegistry("127.0.0.1", 1099);
                        final String[] boundNames = registry.list();
                        System.out.println("bounded services: "+boundNames[0]);
                        map = new MapPaths(impl.leggiOstacoli());
                        
                        for (int i=0; i<5;i++)
                         {creaNemici();}
                        for (int i=0; i<5;i++)
                         {creaAnimali();}
                        
                        System.out.println("server avviato");
                        sorveglia = new Perform_sorveglia();
                        sorveglia.start();
                        aggiornaPlayers = new Perform_aggiornaPlayers();
                        aggiornaPlayers.start();
                        
                        }
                catch (Exception e)
                        {
                        System.out.println("Exception occurred: " + e);
                        e.printStackTrace();
                        }
                }
        
        
        public void  addPlayer(EntityInfo player){
  		  System.out.println(player.nome+" connesso");
  		/*synchronized (playerList)*/ {playerList.add(player);}
        }
        
        public  void removePlayer(String nomePlayer){
    		//it is not generally permissible for one thread to modify a Collection while another thread is iterating
        	Vector<EntityInfo> clonedList;
        	/*synchronized (playerList) */{ clonedList= (Vector<EntityInfo>) playerList.clone();}
        	for(int i=0; i<clonedList.size();i++)
        	 {
        	  if (clonedList.get(i).nome.equals(nomePlayer))
        	    {
        		 /* synchronized (playerList)*/{playerList.remove(i);}
        		  System.out.println(nomePlayer+" disconnesso");
        		  break;
        	    }
        	 } 
        	
        }
        
        
        class Perform_sorveglia extends Thread{
        public void run()
           {
        	while(!isInterrupted())
        	{
        	 synchronized(this){try{wait();}catch(InterruptedException ex){return;}}
        	
           		 Vector<EntityInfo> clonedList;
            	 /*synchronized (playerList) */{ clonedList= (Vector<EntityInfo>) playerList.clone();}
            	 for(EntityInfo player : clonedList)
            	  {
            	   if (player.entityType.equals(EntityType.PLAYER))
            	   {
            		for(CPUentity nemico : nemici)
            	    {
            		  nemico.beAggressive(player);
            	    }
            	   }
            	}
        	 }
          } 
        }
   

        
        
        
        private class Perform_aggiornaPlayers extends Thread{
        	
        	public void run()
        	{
        	 while (!isInterrupted())        	
	    	  {
        		 impl.setPlayersInfo();
		   	     try{Thread.sleep(18);}catch(Exception ex){ex.printStackTrace();}
              }
        	}
       }
}
