package ServerSide;

import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Vector;

import BothSide.Constants.EntityType;
import BothSide.EntityInfo;
import ClientSide.ServicesClient;

public class ServicesImpl extends UnicastRemoteObject implements ServicesInterface
{
	 private Vector<ServicesClient> listeners = new Vector<ServicesClient>();

        public ServicesImpl(String name) throws RemoteException
                {
                super();
                try
                        {
                        Naming.rebind(name, this);
                        }
                catch(Exception e)   {e.printStackTrace();}
                }
        
        
        public Vector<EntityInfo> getRemotePlayersInfo()
                {
        	     return Server.instance.getPlayerList();
                }
        
        

        public void setPlayerInfo(EntityInfo info) throws RemoteException {
        	for (EntityInfo nf:Server.instance.getPlayerList()){
        		if (nf.nome.equals(info.nome))
        			{
        			 nf.stato = info.stato;//stato
        			 nf.orientation = info.orientation;//orientation
        			 nf.location = info.location;
        			}
        	    }
		}


		public void bornPlayer(EntityInfo info) throws RemoteException {
			Server.instance.addPlayer(info);
		}


		public void killPlayer(String nomePlayer) throws RemoteException {
			Server.instance.removePlayer(nomePlayer);			
		}


		@Override
		public String leggiOstacoli() throws RemoteException {
		        String ostacoli = "";
		        try{
		            new File((getClass().getResource("/map/maps/bk.jpg").getFile()).replaceAll("jpg", "txt")).createNewFile();
		            String fileName  = (getClass().getResource("/map/maps/bk.jpg").getFile()).replaceAll("jpg", "txt");
		            FileReader inputFileReader   = new FileReader(fileName);
		            BufferedReader inputStream   = new BufferedReader(inputFileReader);
		            ostacoli = inputStream.readLine();
		            inputStream.close();
		            }
		        catch(Exception ex){ex.printStackTrace();}
		        return ostacoli;

		}


		@Override
		public void assegnaColpoToNemico(String nemico, Point colpo) throws RemoteException {
	        for (CPUentity ai : Server.instance.nemici )
	          { 
	                if (ai.info.nome.equals(nemico))
	                	{
	                		ai.riceviColpo(colpo);
	                		break;
	                	}
	           }
	     }
		
		
		
		
		@Override
		public void assegnaColpoToPlayer(String player, Point colpo) throws RemoteException {
	        Vector<ServicesClient> clonedList = (Vector<ServicesClient>)listeners.clone();
	        for (Enumeration e = clonedList.elements(); e.hasMoreElements(); )
	          {
	            ServicesClient l = (ServicesClient)e.nextElement();
	            try
	              {
	                if (l.getNomeLocalPlayer().equals(player));
	                	{
	                		l.riceviColpo(colpo);
	                		break;
	                	}
	              }
	            catch (RemoteException ee)
	             {listeners.remove(l); System.out.println(" stato rimosso un client");}
	          }
		}
		
		

		  
		   

		    public void addListener (ServicesClient listener)  throws RemoteException
		      {
		        listeners.addElement(listener);
		      }

		    
		    public void removeListener (ServicesClient listener) throws RemoteException
		      {
		        listeners.removeElement(listener);
		      }
		    

		    public void setPlayersInfo ()
		      {
		    	
		        Vector<ServicesClient> clonedList = (Vector<ServicesClient>)listeners.clone();
		        for (Enumeration e = clonedList.elements(); e.hasMoreElements(); )
		          {
		            ServicesClient l = (ServicesClient)e.nextElement();
		            try
		              {
		                setPlayerInfo(l.getRemotePlayerInfo());
		              }
		            catch (RemoteException ee)
		             {listeners.remove(l); System.out.println(" stato rimosso un client");}
		          }
		         synchronized (Server.instance.sorveglia) {Server.instance.sorveglia.notify();}
		     }


			@Override
			public void scalaEnergia(String nemico, int hitValue)throws RemoteException {
		        Vector<ServicesClient> clonedList = (Vector<ServicesClient>)listeners.clone();
		        for (Enumeration e = clonedList.elements(); e.hasMoreElements(); )
		          {
		            ServicesClient client = (ServicesClient)e.nextElement();
		            try
		              {
		            	client.scalaEnergia(nemico, hitValue);
		              }
		            catch (RemoteException ee)
		             {listeners.remove(client); System.out.println(" stato rimosso un client");}
		          }
			}
			
			@Override
			public void sendMessage(String player, String message)throws RemoteException {
		        Vector<ServicesClient> clonedList = (Vector<ServicesClient>)listeners.clone();
		        for (Enumeration e = clonedList.elements(); e.hasMoreElements(); )
		          {
		            ServicesClient client = (ServicesClient)e.nextElement();
		            try
		              {
		            	client.receiveMessage(player, message);
		              }
		            catch (RemoteException ee)
		             {listeners.remove(client); System.out.println(" stato rimosso un client");}
		          }
			}
}