package GUI;

import GUILogica.Panel;
import java.awt.GridBagConstraints;
import java.awt.Toolkit;
import java.io.File;

public class JFCarga extends javax.swing.JFrame {

    private File imagen = null;
    private Panel JP_Fondo = null;
    private String Version = "Version 1.0 2013";
    
    public JFCarga() throws Exception{
        
        initComponents();
        cargarImagen();
        definirVentana();
        cargarComponentes();
        setVisible(true);
        
    }
    
    private void cargarImagen() throws Exception{
    
        try{
        
            String path = System.getProperty("user.dir") + "/Data/GUI/Imagenes/Logon/JFPInicio_Fondo.png";
            imagen = new File(path);
            
        }
        
        catch(Exception e){
        
            throw new Exception(e.getMessage());
        
        }
    
    }
    
    private void definirVentana(){
    
        int X = Toolkit.getDefaultToolkit().getScreenSize().width;
        int Y = Toolkit.getDefaultToolkit().getScreenSize().height;
        int tX = Math.round(getSize().width);
        int tY = Math.round(getSize().height);
        
        X = (X / 2) - (tX / 2);
        Y = (Y / 2) - (tY / 2);
        
        setLocation(X, Y);
        
    }
    
    private void cargarComponentes() throws Exception{
    
        if(imagen != null){
        
            GridBagConstraints GBC = new GridBagConstraints();

            GBC.gridx = 0;
            GBC.gridy = 0;
            GBC.gridwidth = 1;
            GBC.gridheight = 2;
            GBC.fill = GridBagConstraints.BOTH;
            GBC.weightx = 1.0;
            GBC.weighty = 1.0;
            JP_Fondo = new Panel(imagen);
            JP_Fondo.setSize(getSize());
            add(JP_Fondo, GBC);

            JL_Version.setText(Version);
            
        }
        
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JL_Version = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        setUndecorated(true);

        JL_Version.setFont(new java.awt.Font("Ubuntu", 1, 15)); // NOI18N
        JL_Version.setForeground(new java.awt.Color(254, 254, 254));
        JL_Version.setText("Version");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(733, Short.MAX_VALUE)
                .addComponent(JL_Version)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(370, Short.MAX_VALUE)
                .addComponent(JL_Version)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel JL_Version;
    // End of variables declaration//GEN-END:variables
}
