/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package GUI;

import Fabricas.Factory;
import Interfaces.IJuego;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author dalep0
 */
public class JIFBajaJuegoConfirmar extends javax.swing.JInternalFrame {
    private Factory f = null;
    private IJuego ij = null;
    private String categoria = null;
    
    /**
     * Creates new form JIFBajaJuegoConfirmar
     */
    public JIFBajaJuegoConfirmar(Factory f, String categoria) throws Exception{
       
        this.f = f;
        this.categoria = categoria;
        ij = f.getIJuego();
        initComponents();
        cargarJuegos(categoria);
        this.jButtonEliminar.setEnabled(false);
        
    }
    
    private void cargarJuegos(String categoria)throws Exception{
        
        List<String> juegos = ij.listarJuegosXCategoria(categoria);
        DefaultTableModel tm = (DefaultTableModel) jTableJuegos.getModel();
        int rows = 0;
        
        for (String nombre_juego : juegos) {

            tm.addRow(new Object[rows]);
            tm.setValueAt(nombre_juego, rows, 0);
            rows++;
            
        }
        
        this.jTableJuegos.setModel(tm);
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTableJuegos = new javax.swing.JTable();
        jButtonEliminar = new javax.swing.JButton();
        jButtonAtras = new javax.swing.JButton();
        jButtonCancelar = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        jTableJuegos.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null},
                {null}
            },
            new String [] {
                "Juego"
            }
        ));
        jTableJuegos.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jTableJuegos.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableJuegosMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jTableJuegos);

        jButtonEliminar.setText("Eliminar");
        jButtonEliminar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonEliminarActionPerformed(evt);
            }
        });

        jButtonAtras.setText("Atras");
        jButtonAtras.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAtrasActionPerformed(evt);
            }
        });

        jButtonCancelar.setText("Cancelar");
        jButtonCancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelarActionPerformed(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Ubuntu", 1, 16)); // NOI18N
        jLabel1.setText("Seleccione un juego a eliminar");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButtonCancelar, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonAtras, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonEliminar, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonEliminar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonAtras)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonCancelar))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 279, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(37, 37, 37))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonEliminarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonEliminarActionPerformed
        
        int row = this.jTableJuegos.getSelectedRow();
        Object obj = jTableJuegos.getValueAt(row, 0);
        if(obj != null){
            String selRow = obj.toString();
            String[] juego = selRow.split("-");
            try{
                
                
                int retorno = JOptionPane.showConfirmDialog(null, "<html>Está seguro de que quiere eliminar al juego <b>"+juego[1]+"</b></html>","Confirmar" ,JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
                if(retorno == JOptionPane.YES_OPTION){
                    
                    JIFInicial.BloquearJFInicial();
                    this.ij.bajaDeJuego(juego[1]);
                    JOptionPane.showMessageDialog(null, "Se ha eliminado el juego.", "Operación con éxito", JOptionPane.PLAIN_MESSAGE);
                    this.dispose();
                
                }                
                  
            }
            catch (Exception e){
                
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);
            
            }
                        
        }
        
    }//GEN-LAST:event_jButtonEliminarActionPerformed

    private void jButtonAtrasActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAtrasActionPerformed
        try {
            
            JIFBajaJuego JIFBJ = new JIFBajaJuego(f);
            JIFInicial.getJIFInicialjDP().add(JIFBJ);
            JIFInicial.getJIFInicio().setTitle("Baja de Juego");
            this.dispose();
            JIFBJ.setVisible(true);
            
            
        }
        catch (Exception e) {
            
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
            
        }
    }//GEN-LAST:event_jButtonAtrasActionPerformed

    private void jButtonCancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelarActionPerformed
        this.dispose();
        JIFInicial.BloquearJFInicial();
    }//GEN-LAST:event_jButtonCancelarActionPerformed

    private void jTableJuegosMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTableJuegosMouseClicked
        int row = this.jTableJuegos.getSelectedRow();
        Object obj = jTableJuegos.getValueAt(row, 0);
        if(obj != null){
            
            this.jButtonEliminar.setEnabled(true);
            
        }
        else{
            
            this.jButtonEliminar.setEnabled(false);
            
        }
       
    }//GEN-LAST:event_jTableJuegosMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAtras;
    private javax.swing.JButton jButtonCancelar;
    private javax.swing.JButton jButtonEliminar;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTableJuegos;
    // End of variables declaration//GEN-END:variables
}
