/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package GUI;

import Datatypes.*;
import Fabricas.Factory;
import Interfaces.IJuego;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author chonabook
 */
public class JIFConsultaJuego extends javax.swing.JInternalFrame {

    private Factory f = null;
    private IJuego ij = null;
    
    public JIFConsultaJuego(Factory f) throws Exception{
        
        this.f = f;
        this.ij = f.getIJuego();
        initComponents();

    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        
    }
    
    public void cargarCategorias()throws Exception{

        List<DataCategoria> listaC = ij.listarCategorias();
        DefaultTableModel tm = (DefaultTableModel) jTCategorias.getModel();
        int rows = 0;
        
        for (DataCategoria dc : listaC) {

            tm.addRow(new Object[rows]);
            tm.setValueAt(dc.getNombre(), rows, 0);
            rows++;
        }
        
        this.jTCategorias.setModel(tm);
        
    }
    
    public List<String> cargarCatDeJuego(Integer codigo)throws Exception{

        List<DataCategoria> listaC = ij.listarCategoriasDeJuego(codigo);
        List<String> lista = new ArrayList();
        
        for (DataCategoria dc : listaC) {

            lista.add(dc.getNombre());

        }
        
        return lista;
    
    }
    
    public void vaciarjTJuegos(){
    
        DefaultTableModel m = (DefaultTableModel) jTblJuegos.getModel();
        int filas= jTblJuegos.getRowCount();
	for (int i = 0; i < filas; i++) {
            m.removeRow(0);
	}        
    
    }
    
    public void cargarJuegosXCategoria()throws Exception{
    
            int row = jTCategorias.getSelectedRow();
            List<String> listaJ = ij.listarJuegosXCategoria((String) jTCategorias.getValueAt(row, 0));
                        
            DefaultTableModel tm = (DefaultTableModel) jTblJuegos.getModel();
            int rows = 0;

            for (String j : listaJ) {

                tm.addRow(new Object[rows]);
                tm.setValueAt(j, rows, 0);
                rows++;
            }

            this.jTblJuegos.setModel(tm);
    
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane2 = new javax.swing.JScrollPane();
        jTblJuegos = new javax.swing.JTable();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTCategorias = new javax.swing.JTable();
        jBtnAceptar = new javax.swing.JButton();
        jBtnCancelar = new javax.swing.JButton();

        setClosable(true);
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameClosing(evt);
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        jTblJuegos.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "<html><b>Juegos</b></html>"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTblJuegos.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jTblJuegos.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTblJuegosMouseClicked(evt);
            }
        });
        jScrollPane2.setViewportView(jTblJuegos);

        jTCategorias.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "<html><b>Categorias</b><html>"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTCategorias.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jTCategorias.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTCategoriasMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jTCategorias);

        jBtnAceptar.setText("Aceptar");
        jBtnAceptar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAceptarActionPerformed(evt);
            }
        });

        jBtnCancelar.setText("Cancelar");
        jBtnCancelar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnCancelarActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 226, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jBtnAceptar)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 83, Short.MAX_VALUE)
                        .addComponent(jBtnCancelar))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(23, 23, 23)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 199, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBtnAceptar)
                    .addComponent(jBtnCancelar))
                .addContainerGap(29, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBtnCancelarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnCancelarActionPerformed

        this.dispose();
        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_jBtnCancelarActionPerformed

    private void formInternalFrameClosing(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameClosing

        JIFInicial.BloquearJFInicial();
        
    }//GEN-LAST:event_formInternalFrameClosing

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened

        try{
            
            jBtnAceptar.setEnabled(false);
            cargarCategorias();
            centrarVentana();

        }
            
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_formInternalFrameOpened

    private void jBtnAceptarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAceptarActionPerformed

        try{
            
            this.dispose();
            JIFInicial.BloquearJFInicial();

            int row = jTblJuegos.getSelectedRow();
            String str = (String)jTblJuegos.getValueAt(row, 0);
            
            String[] juego = str.split("-");
            DataJuego dj = ij.elegirJuego(juego[1]);    
            
            JIFDatosJuego JIFDatos = new JIFDatosJuego(this.f, dj);
            JIFInicial.getJIFInicialjDP().add(JIFDatos);
            JIFInicial.getJIFInicio().setTitle("Datos del Juego");
            JIFDatos.show();
            JIFInicial.BloquearJFInicial();
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
      
    }//GEN-LAST:event_jBtnAceptarActionPerformed

    private void jTCategoriasMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTCategoriasMouseClicked
        
        try{

            jBtnAceptar.setEnabled(false);
            vaciarjTJuegos();
            cargarJuegosXCategoria();

        }
            
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jTCategoriasMouseClicked

    private void jTblJuegosMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTblJuegosMouseClicked
        
        jBtnAceptar.setEnabled(true);
        
    }//GEN-LAST:event_jTblJuegosMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnAceptar;
    private javax.swing.JButton jBtnCancelar;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTable jTCategorias;
    private javax.swing.JTable jTblJuegos;
    // End of variables declaration//GEN-END:variables
}
