package GUI;

import Datatypes.Archivo;
import Fabricas.Factory;
import Interfaces.IPerfil;
import Logica.JFProgreso;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;


public class JIFInicial extends javax.swing.JFrame {

    //Clase declarada como Singleton, ya que sera instanciada una sola vez
    //y se necesita acceder a ella desde todas las clases.
    //Otro comentario pa que vea el JONITA trolita
    private static JIFInicial INSTANCE = null;
    private Factory f = null;
    private final String dirGUI = System.getProperty("user.dir");
    private String dirservidor = null;
    private File dirServidorFile = null;
    private JFProgreso progreso = null;
    
    private JIFInicial() throws Exception{
    
        initComponents();
        cargarPantallaInicio();
        centrarVentana();
        cargarServidor();
                          
    };
    
    private void habilitarMenus(Boolean opcion){
    
        JMI_LimpiarBase.setEnabled(opcion);
        jMenuEdicion.setEnabled(opcion);
        jMenuVer.setEnabled(opcion);
        jBtnAltaPerfil.setEnabled(opcion);
        jBtnAltaCompra.setEnabled(opcion);
        jBtnAltaComentario.setEnabled(opcion);
        JMI_DatosDePrueba.setEnabled(opcion);
    
    }
    
    public void cargarOpciones() throws Exception {
    
        IPerfil ip = f.getIPerfil();
        
        if(ip.esVaciaBD()){
        
            habilitarMenus(false);
            JMI_DatosDePrueba.setEnabled(true);
        
        }
        
        else{
        
            habilitarMenus(true);
            JMI_DatosDePrueba.setEnabled(false);
        
        }
        
    }
    
    private void crearProgreso(){
    
        progreso = new JFProgreso();
        progreso.setLocationRelativeTo(this);
        progreso.setVisible(true);
    
    }
    
    private void cargarDatosDePrueba() throws Exception{
            
        crearProgreso();   
        
        Runnable ejecutar = new Runnable(){
        
            @Override
            public void run(){
                
                try{
                
                    f.getIPerfil().cargarDatosDePrueba(false);
                    progreso.setVisible(false);
                    progreso.dispose();
                    cargarOpciones();
            
                }
                
                catch(Exception e){

                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);

                }
                    
            }
        
        };
        
        Thread tarea = new Thread(ejecutar);
        
        tarea.start();
    
    }
    
    private void limpiarBD() throws Exception{
            
        crearProgreso();   
        
        Runnable ejecutar = new Runnable(){
        
            @Override
            public void run(){
                
                try{
                
                    f.getIPerfil().limpiarBD();
                    progreso.setVisible(false);
                    progreso.dispose();
                    cargarOpciones();
            
                }
                
                catch(Exception e){

                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);

                }
                    
            }
        
        };
        
        Thread tarea = new Thread(ejecutar);
        
        tarea.start();
    
    }
    
    public void setFactory(Factory f, String dirservidor){
    
        this.f = f;
        this.dirservidor = dirservidor;
    
    }
    
    public String getDirServidor(){
    
        return this.dirservidor;
    
    }
    
    public String getDirGUI(){
    
        return this.dirGUI;
    
    }
    
    private void cargarServidor() throws Exception {
                            
        dirServidorFile = new File(System.getProperty("user.dir") + "/Data/dirServidor.obj");
        
        if(dirServidorFile.exists()){

            Archivo a = new Archivo(dirServidorFile);
            dirservidor = (String) a.leerObjetoDeArchivo();
            
            Integer opcion = JOptionPane.showConfirmDialog(this, "<html><body>El servidor se encuentra actualmente en:<br><br>" + dirservidor + "<br><br>Desea cambiar la dirección?</body></html>", "Confirmación", JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);
            
            if(opcion != 0){
            
                String dirBD = dirservidor + "/Data/Persistencia/Base de Datos/SCDBase.sqlite";
                File confirmar = new File(dirBD);
                
                if(confirmar.exists()){
                
                    f = Factory.getInstance(dirBD);
                    cargarOpciones();
                    this.setVisible(true);

                }
                
                else{
                
                    JOptionPane.showMessageDialog(this, "<html><body>El directorio no contiene al servidor.</body></html>", "Error!", JOptionPane.ERROR_MESSAGE);
                    this.dispose();
                    System.exit(0);
                    
                }
                    
            }
            
            else{
            
                JFCargaServidor cs = new JFCargaServidor();
            
            }
                
        }
        
        else{
        
            JFCargaServidor cs = new JFCargaServidor();
        
        }
            
    }
    
    public static Dimension getDPInicioDimension(){
    
        return JIFInicial.INSTANCE.jDPInicio.getSize();
    
    }
    
    public static javax.swing.JDesktopPane getJIFInicialjDP(){
    
        return JIFInicial.INSTANCE.jDPInicio;
        
    }
    
    public static void setJIFInicialTitle(String title){
    
        JIFInicial.INSTANCE.setTitle(title);
    
    }
    
    private void centrarVentana(){
    
        int X = Toolkit.getDefaultToolkit().getScreenSize().width;
        int Y = Toolkit.getDefaultToolkit().getScreenSize().height;
        int tX = Math.round(getSize().width);
        int tY = Math.round(getSize().height);
        
        X = (X / 2) - (tX / 2);
        Y = (Y / 2) - (tY / 2);
        
        setLocation(X, Y);
        
    }
    
    private void cargarPantallaInicio() throws Exception{
    
        try{
        
            JFCarga JFB = new JFCarga();
            Thread.sleep(1000);
            JFB.dispose();
            JFB.setVisible(false);
            
        }
        
        catch(Exception e){
        
            throw new Exception(e.getMessage());
        
        }
    
    }
    
    private synchronized static void createInstance() throws Exception{
        if (INSTANCE == null) { 
            INSTANCE = new JIFInicial();
        }
    };
    
    public static JIFInicial getInstance() throws Exception{
        createInstance();
        return INSTANCE;
    };
    
    public static JInternalFrame getJIFInicio(){
    
        return JIFInicial.INSTANCE.jInternalFrameInicio;
    
    }
    
    public static JProgressBar getProgresoBarra(){
    
        return JIFInicial.INSTANCE.JPB_ProgresoDatosPrueba;
    
    }
    
    public static JDialog getProgesoVentana(){
    
        return JIFInicial.INSTANCE.JDCargaPrueba;
        
    }
    
    //Funcion que bloquea todos los Componentes de 
    //jTBOeste y JMBTMarket cuando se abre una jInternalFrame
    //de este modo evitamos que se puedan abrir multiples ventanas
    //y el admin se centre solo en la JIF del casos de uso.
    public static void BloquearJFInicial(){
    
        //Bloque de todos los componentes de la TBOeste
        Component[] compMB = JIFInicial.INSTANCE.jMBTMarket.getComponents();
       
        for(int i=0; i <= compMB.length - 1; i++){
        
            compMB[i].setEnabled(!compMB[i].isEnabled());
        
        }
        
        //Bloqueo de todos los componentes de JMenuBarTMarket
        Component[] compTB = JIFInicial.INSTANCE.jTBOeste.getComponents();
        
        for(int i=0; i <= compTB.length - 1; i++){
        
            compTB[i].setEnabled(!compTB[i].isEnabled());
        
        }
        
        //Este boton (Exit) no se bloquea, para permitir la salida rapida
        //de la aplicacion
        compTB[6].setEnabled(true);
        
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JDCargaPrueba = new javax.swing.JDialog();
        JPB_ProgresoDatosPrueba = new javax.swing.JProgressBar();
        jInternalFrameInicio = new javax.swing.JInternalFrame();
        jTBOeste = new javax.swing.JToolBar();
        jBtnAltaPerfil = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jBtnAltaCompra = new javax.swing.JButton();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        jBtnAltaComentario = new javax.swing.JButton();
        jSeparator4 = new javax.swing.JToolBar.Separator();
        jBtnExit = new javax.swing.JButton();
        jDPInicio = new javax.swing.JDesktopPane();
        jMBTMarket = new javax.swing.JMenuBar();
        jMenuSesion = new javax.swing.JMenu();
        JMI_DatosDePrueba = new javax.swing.JMenuItem();
        JMI_LimpiarBase = new javax.swing.JMenuItem();
        jMISalir = new javax.swing.JMenuItem();
        jMenuEdicion = new javax.swing.JMenu();
        jMenuNuevo = new javax.swing.JMenu();
        jMIAltaCat = new javax.swing.JMenuItem();
        jMIAltaPerfil = new javax.swing.JMenuItem();
        jMIAltaComentario = new javax.swing.JMenuItem();
        jMIComprar = new javax.swing.JMenuItem();
        jMenuEditar = new javax.swing.JMenu();
        jMenuItem2 = new javax.swing.JMenuItem();
        jMIModificarPerfil = new javax.swing.JMenuItem();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuVer = new javax.swing.JMenu();
        jMIVerJuegos = new javax.swing.JMenuItem();
        jMIVerPerfiles = new javax.swing.JMenuItem();
        jMIVerRegistros = new javax.swing.JMenuItem();

        JDCargaPrueba.setTitle("Cargando Datos de Prueba");
        JDCargaPrueba.setAlwaysOnTop(true);
        JDCargaPrueba.setResizable(false);

        javax.swing.GroupLayout JDCargaPruebaLayout = new javax.swing.GroupLayout(JDCargaPrueba.getContentPane());
        JDCargaPrueba.getContentPane().setLayout(JDCargaPruebaLayout);
        JDCargaPruebaLayout.setHorizontalGroup(
            JDCargaPruebaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JDCargaPruebaLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JPB_ProgresoDatosPrueba, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
                .addContainerGap())
        );
        JDCargaPruebaLayout.setVerticalGroup(
            JDCargaPruebaLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(JDCargaPruebaLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(JPB_ProgresoDatosPrueba, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("TPlay Market");

        jInternalFrameInicio.setTitle("Inicio");
        jInternalFrameInicio.setOpaque(false);
        jInternalFrameInicio.setPreferredSize(new java.awt.Dimension(800, 750));
        try {
            jInternalFrameInicio.setSelected(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jInternalFrameInicio.setVisible(true);
        jInternalFrameInicio.addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
                jInternalFrameInicioInternalFrameClosed(evt);
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        jTBOeste.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jTBOeste.setFloatable(false);
        jTBOeste.setOrientation(javax.swing.SwingConstants.VERTICAL);
        jTBOeste.setRollover(true);

        jBtnAltaPerfil.setIcon(new javax.swing.ImageIcon(dirGUI + "/Data/GUI/Iconos/AltaDePerfil.png"));
        jBtnAltaPerfil.setToolTipText("Alta de Perfil - TMarket");
        jBtnAltaPerfil.setFocusable(false);
        jBtnAltaPerfil.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnAltaPerfil.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnAltaPerfil.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAltaPerfilActionPerformed(evt);
            }
        });
        jTBOeste.add(jBtnAltaPerfil);
        jTBOeste.add(jSeparator1);

        jBtnAltaCompra.setIcon(new javax.swing.ImageIcon(dirGUI + "/Data/GUI/Iconos/Compra.png"));
        jBtnAltaCompra.setToolTipText("Comprar Juegos - TMarket");
        jBtnAltaCompra.setFocusable(false);
        jBtnAltaCompra.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnAltaCompra.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnAltaCompra.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAltaCompraActionPerformed(evt);
            }
        });
        jTBOeste.add(jBtnAltaCompra);
        jTBOeste.add(jSeparator3);

        jBtnAltaComentario.setIcon(new javax.swing.ImageIcon(dirGUI + "/Data/GUI/Iconos/AltaDeComentario.png"));
        jBtnAltaComentario.setToolTipText("Alta Comentario - TMarket");
        jBtnAltaComentario.setFocusable(false);
        jBtnAltaComentario.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnAltaComentario.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnAltaComentario.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnAltaComentarioActionPerformed(evt);
            }
        });
        jTBOeste.add(jBtnAltaComentario);
        jTBOeste.add(jSeparator4);

        jBtnExit.setIcon(new javax.swing.ImageIcon(dirGUI + "/Data/GUI/Iconos/Salir.png"));
        jBtnExit.setToolTipText("Salir - TMarket");
        jBtnExit.setFocusable(false);
        jBtnExit.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jBtnExit.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jBtnExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnExitActionPerformed(evt);
            }
        });
        jTBOeste.add(jBtnExit);

        jDPInicio.setBackground(new java.awt.Color(1, 1, 1));
        jDPInicio.setDoubleBuffered(true);
        jDPInicio.setOpaque(false);
        jDPInicio.addContainerListener(new java.awt.event.ContainerAdapter() {
            public void componentAdded(java.awt.event.ContainerEvent evt) {
                jDPInicioComponentAdded(evt);
            }
            public void componentRemoved(java.awt.event.ContainerEvent evt) {
                jDPInicioComponentRemoved(evt);
            }
        });

        jMenuSesion.setText("Sesión");

        JMI_DatosDePrueba.setText("Datos de Prueba");
        JMI_DatosDePrueba.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JMI_DatosDePruebaActionPerformed(evt);
            }
        });
        jMenuSesion.add(JMI_DatosDePrueba);

        JMI_LimpiarBase.setText("Limpiar la Base");
        JMI_LimpiarBase.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                JMI_LimpiarBaseActionPerformed(evt);
            }
        });
        jMenuSesion.add(JMI_LimpiarBase);

        jMISalir.setText("Salir");
        jMISalir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMISalirActionPerformed(evt);
            }
        });
        jMenuSesion.add(jMISalir);

        jMBTMarket.add(jMenuSesion);

        jMenuEdicion.setText("Editar");

        jMenuNuevo.setText("Nuevo");

        jMIAltaCat.setText("Categoría");
        jMIAltaCat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIAltaCatActionPerformed(evt);
            }
        });
        jMenuNuevo.add(jMIAltaCat);

        jMIAltaPerfil.setText("Perfil");
        jMIAltaPerfil.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIAltaPerfilActionPerformed(evt);
            }
        });
        jMenuNuevo.add(jMIAltaPerfil);

        jMIAltaComentario.setText("Comentario");
        jMIAltaComentario.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIAltaComentarioActionPerformed(evt);
            }
        });
        jMenuNuevo.add(jMIAltaComentario);

        jMIComprar.setText("Comprar Juego");
        jMIComprar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIComprarActionPerformed(evt);
            }
        });
        jMenuNuevo.add(jMIComprar);

        jMenuEdicion.add(jMenuNuevo);

        jMenuEditar.setText("Modificar");

        jMenuItem2.setText("Baja de Juego");
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });
        jMenuEditar.add(jMenuItem2);

        jMIModificarPerfil.setText("Perfil");
        jMIModificarPerfil.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIModificarPerfilActionPerformed(evt);
            }
        });
        jMenuEditar.add(jMIModificarPerfil);

        jMenuItem1.setText("Versiones Pendientes");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenuEditar.add(jMenuItem1);

        jMenuEdicion.add(jMenuEditar);

        jMBTMarket.add(jMenuEdicion);

        jMenuVer.setText("Ver");

        jMIVerJuegos.setText("Juegos");
        jMIVerJuegos.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIVerJuegosActionPerformed(evt);
            }
        });
        jMenuVer.add(jMIVerJuegos);

        jMIVerPerfiles.setText("Perfiles");
        jMIVerPerfiles.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIVerPerfilesActionPerformed(evt);
            }
        });
        jMenuVer.add(jMIVerPerfiles);

        jMIVerRegistros.setText("Ver Registros");
        jMIVerRegistros.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMIVerRegistrosActionPerformed(evt);
            }
        });
        jMenuVer.add(jMIVerRegistros);

        jMBTMarket.add(jMenuVer);

        jInternalFrameInicio.setJMenuBar(jMBTMarket);

        javax.swing.GroupLayout jInternalFrameInicioLayout = new javax.swing.GroupLayout(jInternalFrameInicio.getContentPane());
        jInternalFrameInicio.getContentPane().setLayout(jInternalFrameInicioLayout);
        jInternalFrameInicioLayout.setHorizontalGroup(
            jInternalFrameInicioLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jInternalFrameInicioLayout.createSequentialGroup()
                .addComponent(jTBOeste, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jDPInicio, javax.swing.GroupLayout.DEFAULT_SIZE, 683, Short.MAX_VALUE)
                .addContainerGap())
        );
        jInternalFrameInicioLayout.setVerticalGroup(
            jInternalFrameInicioLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTBOeste, javax.swing.GroupLayout.DEFAULT_SIZE, 697, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jInternalFrameInicioLayout.createSequentialGroup()
                .addComponent(jDPInicio)
                .addContainerGap())
        );

        getContentPane().add(jInternalFrameInicio, java.awt.BorderLayout.PAGE_START);
        try {
            jInternalFrameInicio.setMaximum(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void jMIAltaCatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIAltaCatActionPerformed
       
        try{
        
            jInternalFrameInicio.setTitle("Alta de Categoría");
            JIFAltaCategoria JIFCategoria = new JIFAltaCategoria(this.f);
            jDPInicio.add(JIFCategoria);
            JIFCategoria.show();
            BloquearJFInicial();
            
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jMIAltaCatActionPerformed

    private void jMISalirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMISalirActionPerformed

        this.dispose();
        System.exit(0);//AGREGUE EXIT PARA CERRAR
        
    }//GEN-LAST:event_jMISalirActionPerformed

    private void jMIAltaPerfilActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIAltaPerfilActionPerformed

        try{
        
            jInternalFrameInicio.setTitle("Alta de Perfíl");
            JIFAltaPerfil JIFA = new JIFAltaPerfil(this.f);
            JIFA.componentesInicio();
            jDPInicio.add(JIFA);
            JIFA.show();
            BloquearJFInicial();
            
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jMIAltaPerfilActionPerformed

    private void jMIAltaComentarioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIAltaComentarioActionPerformed
        
        try{

            jInternalFrameInicio.setTitle("Comentario");
            JIFIngresarComentario JIFAltaComentario = new JIFIngresarComentario(this.f);
            jDPInicio.add(JIFAltaComentario);
            JIFAltaComentario.show();
            BloquearJFInicial();

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
            
    }//GEN-LAST:event_jMIAltaComentarioActionPerformed

    private void jMIModificarPerfilActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIModificarPerfilActionPerformed

        try{
            
            jInternalFrameInicio.setTitle("Modificar Perfíl");
            JIFModificarPerfil JIFM = new JIFModificarPerfil(this.f);
            jDPInicio.add(JIFM);
            BloquearJFInicial();

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
            
    }//GEN-LAST:event_jMIModificarPerfilActionPerformed

    private void jMIComprarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIComprarActionPerformed
  
        try{
        
            jInternalFrameInicio.setTitle("Comprar");
            JIFComprarJuego JIFAltaCompra = new JIFComprarJuego(this.f);
            jDPInicio.add(JIFAltaCompra);
            JIFAltaCompra.show();
            JIFAltaCompra.setBloquearComponentes();
            BloquearJFInicial();
        
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
            
    }//GEN-LAST:event_jMIComprarActionPerformed

    private void jBtnAltaPerfilActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAltaPerfilActionPerformed
    
        try{
        
            jInternalFrameInicio.setTitle("Alta de Perfíl");
            JIFAltaPerfil JIFA = new JIFAltaPerfil(this.f);
            JIFA.componentesInicio();
            jDPInicio.add(JIFA);
            JIFA.show();
            BloquearJFInicial();
            
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jBtnAltaPerfilActionPerformed

    private void jBtnAltaCompraActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAltaCompraActionPerformed

        try{
        
            jInternalFrameInicio.setTitle("Compra");
            JIFComprarJuego JIFAltaCompra = new JIFComprarJuego(this.f);
            jDPInicio.add(JIFAltaCompra);
            JIFAltaCompra.show();
            JIFAltaCompra.setBloquearComponentes();
            BloquearJFInicial();
            
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jBtnAltaCompraActionPerformed

    private void jBtnAltaComentarioActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnAltaComentarioActionPerformed

        try{
        
            jInternalFrameInicio.setTitle("Comentario");
            JIFIngresarComentario JIFAltaComentario = new JIFIngresarComentario(this.f);
            jDPInicio.add(JIFAltaComentario);
            JIFAltaComentario.show();
            BloquearJFInicial();

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
            
    }//GEN-LAST:event_jBtnAltaComentarioActionPerformed

    private void jBtnExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnExitActionPerformed

        this.dispose();
        System.exit(0);//AGREGUE EXIT PARA CERRAR
        
    }//GEN-LAST:event_jBtnExitActionPerformed

    private void jMIVerPerfilesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIVerPerfilesActionPerformed
        try {
            jInternalFrameInicio.setTitle("Consulta de Perfíl");
            JIFConsultaPerfil JIFVerPerfil = new JIFConsultaPerfil(this.f);
            jDPInicio.add(JIFVerPerfil);
            JIFVerPerfil.setVisible(true);
            BloquearJFInicial();
        } catch (Exception ex) {
            Logger.getLogger(JIFInicial.class.getName()).log(Level.SEVERE, null, ex);
        }
        
    }//GEN-LAST:event_jMIVerPerfilesActionPerformed

    private void jMIVerJuegosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIVerJuegosActionPerformed

        try{
        
            jInternalFrameInicio.setTitle("Consulta de Juego");
            JIFConsultaJuego JIFVerJuego = new JIFConsultaJuego(this.f);
            jDPInicio.add(JIFVerJuego);
            JIFVerJuego.setVisible(true);
            BloquearJFInicial();
            
        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jMIVerJuegosActionPerformed

    private void jInternalFrameInicioInternalFrameClosed(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_jInternalFrameInicioInternalFrameClosed

        this.dispose();
        System.exit(0);//AGREGUE EXIT PARA CERRAR
        
    }//GEN-LAST:event_jInternalFrameInicioInternalFrameClosed

    private void jDPInicioComponentRemoved(java.awt.event.ContainerEvent evt) {//GEN-FIRST:event_jDPInicioComponentRemoved

        jInternalFrameInicio.setTitle("Inicio");

    }//GEN-LAST:event_jDPInicioComponentRemoved

    private void jDPInicioComponentAdded(java.awt.event.ContainerEvent evt) {//GEN-FIRST:event_jDPInicioComponentAdded

        Dimension D = new Dimension(this.getSize().width, this.getSize().height - 30);
        jInternalFrameInicio.setPreferredSize(D);

    }//GEN-LAST:event_jDPInicioComponentAdded

    private void JMI_DatosDePruebaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JMI_DatosDePruebaActionPerformed
        
        try{
        
            cargarDatosDePrueba();

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }

    }//GEN-LAST:event_JMI_DatosDePruebaActionPerformed

    private void JMI_LimpiarBaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_JMI_LimpiarBaseActionPerformed

        try{
        
            limpiarBD();

        }
        
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }

    }//GEN-LAST:event_JMI_LimpiarBaseActionPerformed

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        
        try{
            jInternalFrameInicio.setTitle("Versiones pendientes");
            JIFVersionado JIFV = new JIFVersionado(this.f);
            jDPInicio.add(JIFV);
            JIFV.setVisible(true);
            BloquearJFInicial();
            
        }
        catch(Exception e){
            
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
       
        }
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed
         try{
            jInternalFrameInicio.setTitle("Baja de Juego");
            JIFBajaJuego JIFBJ = new JIFBajaJuego(this.f);
            jDPInicio.add(JIFBJ);
            JIFBJ.setVisible(true);
            BloquearJFInicial();
        }
        catch(Exception e){
            
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
       
        }
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    private void jMIVerRegistrosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMIVerRegistrosActionPerformed
        
         
        try {
            
            jInternalFrameInicio.setTitle("Ver Registros");
            JIFVerRegistros JIFVR = new JIFVerRegistros(this.f);
            jDPInicio.add(JIFVR);
            JIFVR.setVisible(true);
            BloquearJFInicial();
            
        }
        catch (Exception e) {
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }
        
    }//GEN-LAST:event_jMIVerRegistrosActionPerformed
    
    /**
     * @param args the command line arguments
     */
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JDialog JDCargaPrueba;
    private javax.swing.JMenuItem JMI_DatosDePrueba;
    private javax.swing.JMenuItem JMI_LimpiarBase;
    private javax.swing.JProgressBar JPB_ProgresoDatosPrueba;
    private javax.swing.JButton jBtnAltaComentario;
    private javax.swing.JButton jBtnAltaCompra;
    private javax.swing.JButton jBtnAltaPerfil;
    private javax.swing.JButton jBtnExit;
    private javax.swing.JDesktopPane jDPInicio;
    private javax.swing.JInternalFrame jInternalFrameInicio;
    private javax.swing.JMenuBar jMBTMarket;
    private javax.swing.JMenuItem jMIAltaCat;
    private javax.swing.JMenuItem jMIAltaComentario;
    private javax.swing.JMenuItem jMIAltaPerfil;
    private javax.swing.JMenuItem jMIComprar;
    private javax.swing.JMenuItem jMIModificarPerfil;
    private javax.swing.JMenuItem jMISalir;
    private javax.swing.JMenuItem jMIVerJuegos;
    private javax.swing.JMenuItem jMIVerPerfiles;
    private javax.swing.JMenuItem jMIVerRegistros;
    private javax.swing.JMenu jMenuEdicion;
    private javax.swing.JMenu jMenuEditar;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JMenu jMenuNuevo;
    private javax.swing.JMenu jMenuSesion;
    private javax.swing.JMenu jMenuVer;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JToolBar.Separator jSeparator4;
    private javax.swing.JToolBar jTBOeste;
    // End of variables declaration//GEN-END:variables
}
