/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package GUI;


import Datatypes.DataJuego;
import Datatypes.DataVersion;
import Fabricas.Factory;
import Interfaces.IJuego;
import Interfaces.IVersion;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author chonabook
 */
public class JIFVersionesJuego extends javax.swing.JInternalFrame {

    private IVersion iv = null;
    //private DataVersion dv = null;
    private DataJuego djuego = null;
    
    public JIFVersionesJuego(Factory f, DataJuego dj) throws Exception {
        
        this.djuego = dj;
        this.iv = f.getIVersion();       
        
        initComponents();
        
    }
    
    private void centrarVentana(){
        
        Dimension desktopSize = JIFInicial.getDPInicioDimension();
        Dimension jInternalFrameSize = this.getSize();
        this.setLocation((desktopSize.width - jInternalFrameSize.width)/2,
                                   (desktopSize.height- jInternalFrameSize.height)/2);
        
    }    
    
    private void cargarVersiones() throws Exception{
    
        List<DataVersion> listaV = iv.listarAprobadas(djuego.getNombre());
        DefaultTableModel tm = (DefaultTableModel) tblAprobadas.getModel();
        int rows = 0;
        
        for (DataVersion dv1 : listaV) {

            tm.addRow(new Object[rows]);
            tm.setValueAt(dv1.getVersion(), rows, 0);
            tm.setValueAt(dv1.getTamanio(), rows, 1);
            rows++;
        }        
    
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane2 = new javax.swing.JScrollPane();
        tblAprobadas = new javax.swing.JTable();
        lblAprobadas = new javax.swing.JLabel();
        btnAprobadas = new javax.swing.JButton();

        setClosable(true);
        setTitle("Versiones Aprobadas");
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
        });

        tblAprobadas.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Numero", "Tamanio"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, true
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane2.setViewportView(tblAprobadas);

        lblAprobadas.setText("Versiones Aprobadas:");

        btnAprobadas.setText("Aceptar");
        btnAprobadas.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAprobadasActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 609, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblAprobadas)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(btnAprobadas)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblAprobadas)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE)
                .addComponent(btnAprobadas)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void btnAprobadasActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAprobadasActionPerformed
                
        this.dispose();         
        
    }//GEN-LAST:event_btnAprobadasActionPerformed

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened
        
        try{
        
            cargarVersiones();
            centrarVentana();
        
        }
            
        catch(Exception e){
        
            JOptionPane.showMessageDialog(this, "<html><b>" + e.getMessage() + "</b></html>", "Error!", JOptionPane.ERROR_MESSAGE, null);
        
        }        
        
    }//GEN-LAST:event_formInternalFrameOpened

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAprobadas;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel lblAprobadas;
    private javax.swing.JTable tblAprobadas;
    // End of variables declaration//GEN-END:variables
}
