package ing.lightDogs.turetJson;

//import java.util.logging.Logger;

import javax.persistence.EntityManager;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parseturet extends DefaultHandler {
//	private static final Logger log = Logger.getLogger(Parseturet.class.getName());
	// booleans that check whether it's in a specific tag or not
	static Turet t;
	boolean _inPlacemark = false,
			_inAddress = false, 
			_inDesc = false, 
			_inCoordinates = false;
	int ok=0;
	int ko=0;
	String error="";

	/**
	 * This gets called at the start of an element. Here we're also setting the
	 * booleans to true if it's at that specific tag. (so we know where we are)
	 * 
	 * @param namespaceURI
	 * @param localName
	 * @param qName
	 * @param atts
	 * @throws SAXException
	 */
	@Override
	public void startElement(String namespaceURI, String localName,
			String qName, Attributes atts) throws SAXException {
//		log.info("startElement: " + qName);	
		
		if (qName.equalsIgnoreCase("PLACEMARK")) {
			_inPlacemark = true;
			t = new Turet();
		}
		else if (qName.equalsIgnoreCase("NAME")) {
			_inAddress = true;
		}
		else if (qName.equalsIgnoreCase("DESCRIPTION")) {
			_inDesc = true;
		}
		else if (qName.equalsIgnoreCase("COORDINATES")) {
			_inCoordinates = true;
		}
		
	}

	/**
	 * Calling when we're within an element. Here we're checking to see if there
	 * is any content in the tags that we're interested in and populating it in
	 * the Config object.
	 * 
	 * @param ch
	 * @param start
	 * @param length
	 */
	@Override
	public void characters(char ch[], int start, int length) {
		String chars = new String(ch, start, length);
		chars = chars.trim();

		if (_inPlacemark) {
			_inPlacemark = false;
			t.setConfirmed(true);
		} 
		if (_inAddress) {
			t.setAddress(chars);
//			log.info("Address: " + chars);	
			_inAddress = false;
		}
		else if (_inDesc) {
			t.setDescription(chars);
//			log.info("Desc: " + chars);	
			_inDesc = false;
		}
		else if (_inCoordinates) {
			t.setCoordinates(chars);
//			log.info("Coordinates: " + chars);	
			_inCoordinates = false;
		}
	}

	/**
	 * Called at the end of the element. Setting the booleans to false, so we
	 * know that we've just left that tag.
	 * 
	 * @param namespaceURI
	 * @param localName
	 * @param qName
	 * @throws SAXException
	 */

	@Override
	public void endElement(String namespaceURI, String localName, String qName)
			throws SAXException {
//		log.info("endElement: " + qName);	
		if (qName.equalsIgnoreCase("PLACEMARK")) {
//			log.info("try to insert in datastore");
			EntityManager em = EMFService.get().createEntityManager();
			if (em.find(Turet.class, t.address) == null) {
				try {
					em.persist(t);
//					log.info(t.toJson() + " inserted");
					ok++;
				} finally {
					em.close();
				}
			} else {
//				log.info(t.toJson() + " exists in datastore");
				ko++;
				error = error.concat(t.toJson());
			}
			_inPlacemark = false;
			
		} 
		
	}

}
