package br.com.frbb.ugvbr.camera;

import android.app.Activity;

import android.view.SurfaceHolder;
import android.view.View;

public abstract class CameraCapturer {
	
	protected Activity activity;
	
	protected SurfaceHolder surfaceHolder;
	protected PreviewCallback previewCallback;
	
	protected int width;
	protected int height;
	protected int screenOrientation;
	
	protected CameraCapturer (Activity activity) {
		this.activity = activity;
	}
	
	public void setScreenOrientation(int orientation) {
		this.screenOrientation = orientation;
	}
	
	public void setupCamera(int width, int height) {
		this.width = width;
		this.height = height;
	}
	
	public void setPreviewCallback(PreviewCallback previewCallback){
		this.previewCallback = previewCallback;
	}
	
	public View getPreview() {
		CameraPreview cameraPreview;
		
		cameraPreview = new CameraPreview(activity, this);
		
		return cameraPreview;
	}
	
	protected void setSurfaceHolder(SurfaceHolder surfaceHolder) {
		this.surfaceHolder = surfaceHolder;
	}
	
	public abstract void setPreviewChannel(CameraChannel cameraChannel);
	
	public abstract boolean openCamera();
	
	public abstract void releaseCamera();
}
