package com.vishudha.timer.domain;

public enum VishudhaTimeType {
	YEAR ("Year", "%Y", 0, 365 * 24 * 60 * 60 * 1000L), 
	MONTH("Month", "%L", 1, 30 * 24 * 60 * 60 * 1000L), 
	DAYS("Day", "%D", 2, 24 * 60 * 60 * 1000L), 
	HOURS("Hour", "%H", 3, 60 * 60 * 1000L), 
	MINUTES("Minute", "%M", 4, 60 * 1000L), 
	SECONDS("Second", "%S", 5, 1000L), 
	TENTH_OF_A_SECONDS("Tenth of a Second", "%T", 6, 100L),
	MILI_SECONDS("mili Second", "%I", 7, 1L);

	private final String displayName;
	private final String formater;
	private final int formaterId;
	private final long divisionFactor;

	private VishudhaTimeType(String displayName, String formater, int formaterId, long divisionFactor) {
		this.displayName = displayName;
		this.formater = formater;
		this.formaterId = formaterId;
		this.divisionFactor = divisionFactor;
	}

	public String getDisplayName() {
		return displayName;
	}

	public String getFormater() {
		return formater;
	}

	public int getFormaterId() {
		return formaterId;
	}

	public long getDivisionFactor() {
		return divisionFactor;
	}	
	
	public long getDefaultInterval() {
		return getDivisionFactor();
	}
	
	public String getFormaterParamId() {
		return "{" + formaterId + "}";
	}
}
