package com.vishudha.timer.event;

import java.io.Serializable;

import com.vishudha.timer.VishudhaHelper;

/**
 * VishudhaEvent.java
 * @author Anish Jain
 * @since 2011
 * @version 1.0
 */
@SuppressWarnings("serial")
public class VishudhaEvent <T> implements Serializable {
	private long value;
	private T eventHandler;
	private VishudhaEventType eventType;

	/**
	 * @param value
	 * @param eventHandler
	 */
	public VishudhaEvent(long value, T task, VishudhaEventType eventType) {
		this.value = value;
		this.eventHandler = task;
		this.eventType = eventType;
	}

	public long getValue() {
		return value;
	}

	public void setValue(long value) {
		this.value = value;
	}

	public T getEventHandler() {
		return eventHandler;
	}

	public void setEventHandler(T task) {
		this.eventHandler = task;
	}
	
	public VishudhaEventType getEventType() {
		return eventType;
	}

	public void setEventType(VishudhaEventType eventType) {
		this.eventType = eventType;
	}

	public String getMessage(String formate) {
		return VishudhaHelper.getMessage(formate, value);
	}
}
