/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.volatileengine.renderer.lwjgl;

import org.lwjgl.opengl.Display;

import com.volatileengine.platform.AbstractPlatform;
import com.volatileengine.scene.WindowSurface;
import com.volatileengine.util.Timer;

/**
 * 
 * @author Owner
 */
public class LWJGLPlatform extends AbstractPlatform {

	private WindowSurface surface;
	private boolean destroy = false;

	private Timer timer;

	public LWJGLPlatform() {
		super();
		renderer = new LWJGLGPU();
		timer = new Timer();
	}

	@Override
	public void start() {
		Thread t = new Thread(new Runnable() {

			public void run() {
				surface.create();
				renderer.initialise();
				while (!destroy) {
					Display.processMessages();
					timer.tick();
					if (Display.isDirty() || Display.isVisible()) {
						Display.setTitle("FPS: " + timer.getFPS());
						render();
					}
					Thread.yield();
				}
				Display.destroy();
			}
		});
		t.setName("LWJGL Rendering Thread");
		t.start();
	}

	@Override
	public void destory() {
		destroy = true;
	}

	@Override
	public void createWindow(WindowSurface surface) {
		this.surface = surface;
	}
}
