/*
 * Copyright (c) 2004-2005, Volatile-Engine All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * Neither the name of the Volatile-Engine nor the
 * names of its contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package com.volatileengine.datatypes;

import java.nio.FloatBuffer;

/**
 * TODO: Document me
 * 
 * @author ChaosDeathFish
 */
public class InterleavedArrayFloat extends ArrayFloat {
	public ArrayElement<FloatBuffer>[] children;

	public InterleavedArrayFloat(int[] sizes) {
		this(sizes, sizes.length, 0);
	}

	public InterleavedArrayFloat(int[] sizes, int length) {
		this(sizes, length, sizes.length);
	}

	@SuppressWarnings("unchecked")
	public InterleavedArrayFloat(int[] sizes, int length, int numSizes) {
		super(totalSize(sizes, numSizes), length);

		int off = 0;
		children = new ArrayElement[numSizes];
		for (int i = 0; i < numSizes; i++) {
			children[i] = new ArrayElement<FloatBuffer>(this, off, sizes[i]);
			off += sizes[i];
		}
	}

	private static int totalSize(int[] sizes, int numSizes) {
		int size = 0;
		for (int i = 0; i < numSizes; i++) {
			size += sizes[i];
		}

		return size;
	}

	@Override
	public ArrayElement<FloatBuffer> getChildAt(int index) {
		return children[index];
	}

	@Override
	public int getChildCount() {
		return children.length;
	}

	public AbstractArray<FloatBuffer> asArray() {
		return this;
	}
}
